/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.stateview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.RelativeLayout;
import com.github.nukc.stateview.R;

public class StateView
extends View {
    private int mEmptyResource;
    private int mRetryResource;
    private int mLoadingResource;
    private int mEmptyViewId;
    private int mRetryViewId;
    private int mLoadingViewId;
    private View mEmptyView;
    private View mRetryView;
    private View mLoadingView;
    private LayoutInflater mInflater;
    private OnRetryClickListener mRetryClickListener;
    private RelativeLayout.LayoutParams mLayoutParams;

    public static StateView inject(Activity activity) {
        ViewGroup rootView = (ViewGroup)activity.getWindow().getDecorView();
        StateView stateView = new StateView((Context)activity);
        rootView.addView((View)stateView);
        return stateView;
    }

    public static StateView inject(ViewGroup parent) {
        StateView stateView = new StateView(parent.getContext());
        parent.addView((View)stateView);
        return stateView;
    }

    public StateView(Context context) {
        this(context, null);
    }

    public StateView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StateView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mLayoutParams = attrs == null ? new RelativeLayout.LayoutParams(-1, -1) : new RelativeLayout.LayoutParams(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StateView);
        this.mEmptyResource = a.getResourceId(R.styleable.StateView_emptyResource, 0);
        this.mRetryResource = a.getResourceId(R.styleable.StateView_retryResource, 0);
        this.mLoadingResource = a.getResourceId(R.styleable.StateView_loadingResource, 0);
        this.mEmptyViewId = a.getResourceId(R.styleable.StateView_emptyViewId, -1);
        this.mRetryViewId = a.getResourceId(R.styleable.StateView_retryViewId, -1);
        this.mLoadingViewId = a.getResourceId(R.styleable.StateView_loadingViewId, -1);
        a.recycle();
        if (this.mEmptyResource == 0) {
            this.mEmptyResource = R.layout.view_empty;
        }
        if (this.mRetryResource == 0) {
            this.mRetryResource = R.layout.view_retry;
        }
        if (this.mLoadingResource == 0) {
            this.mLoadingResource = R.layout.view_loading;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(0, 0);
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void draw(Canvas canvas) {
    }

    protected void dispatchDraw(Canvas canvas) {
    }

    public void setVisibility(int visibility) {
        this.setVisibility(this.mEmptyView, visibility);
        this.setVisibility(this.mRetryView, visibility);
        this.setVisibility(this.mLoadingView, visibility);
    }

    private void setVisibility(View view, int visibility) {
        if (view != null) {
            view.setVisibility(visibility);
        }
    }

    public void showContent() {
        this.setVisibility(8);
    }

    public View showEmpty() {
        if (this.mEmptyView == null) {
            this.mEmptyView = this.inflate(this.mEmptyResource, this.mEmptyViewId);
        }
        this.showView(this.mEmptyView);
        return this.mEmptyView;
    }

    public View showRetry() {
        if (this.mRetryView == null) {
            this.mRetryView = this.inflate(this.mRetryResource, this.mRetryViewId);
            this.mRetryView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (StateView.this.mRetryClickListener != null) {
                        StateView.this.showLoading();
                        StateView.this.mRetryView.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                StateView.this.mRetryClickListener.onRetryClick();
                            }
                        }, 200L);
                    }
                }
            });
        }
        this.showView(this.mRetryView);
        return this.mRetryView;
    }

    public View showLoading() {
        if (this.mLoadingView == null) {
            this.mLoadingView = this.inflate(this.mLoadingResource, this.mLoadingViewId);
            this.mLoadingView.setClickable(true);
        }
        this.showView(this.mLoadingView);
        return this.mLoadingView;
    }

    private void showView(View view) {
        this.setVisibility(view, 0);
        if (this.mEmptyView == view) {
            this.setVisibility(this.mLoadingView, 8);
            this.setVisibility(this.mRetryView, 8);
        } else if (this.mLoadingView == view) {
            this.setVisibility(this.mEmptyView, 8);
            this.setVisibility(this.mRetryView, 8);
        } else {
            this.setVisibility(this.mEmptyView, 8);
            this.setVisibility(this.mLoadingView, 8);
        }
    }

    public View inflate(@LayoutRes int layoutResource, @IdRes int inflatedId) {
        ViewParent viewParent = this.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            if (layoutResource != 0) {
                ViewGroup parent = (ViewGroup)viewParent;
                LayoutInflater factory = this.mInflater != null ? this.mInflater : LayoutInflater.from((Context)this.getContext());
                View view = factory.inflate(layoutResource, parent, false);
                if (inflatedId != -1) {
                    view.setId(inflatedId);
                }
                int index = parent.indexOfChild((View)this);
                ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                if (layoutParams != null) {
                    if (parent instanceof RelativeLayout) {
                        parent.addView(view, index, (ViewGroup.LayoutParams)this.mLayoutParams);
                    } else {
                        parent.addView(view, index, layoutParams);
                    }
                } else {
                    parent.addView(view, index);
                }
                if (this.mLoadingView != null && this.mRetryView != null && this.mEmptyView != null) {
                    parent.removeViewInLayout((View)this);
                }
                return view;
            }
            throw new IllegalArgumentException("StateView must have a valid layoutResource");
        }
        throw new IllegalStateException("StateView must have a non-null ViewGroup viewParent");
    }

    public int getEmptyResource() {
        return this.mEmptyResource;
    }

    public void setEmptyResource(@LayoutRes int emptyResource) {
        this.mEmptyResource = emptyResource;
    }

    public int getErrorResource() {
        return this.mRetryResource;
    }

    public void setErrorResource(@LayoutRes int errorResource) {
        this.mRetryResource = errorResource;
    }

    public int getEmptyViewId() {
        return this.mEmptyViewId;
    }

    public void setEmptyViewId(@IdRes int emptyViewId) {
        this.mEmptyViewId = emptyViewId;
    }

    public int getErrorViewId() {
        return this.mRetryViewId;
    }

    public void setErrorViewId(@IdRes int errorViewId) {
        this.mRetryViewId = errorViewId;
    }

    public LayoutInflater getInflater() {
        return this.mInflater;
    }

    public void setInflater(LayoutInflater inflater) {
        this.mInflater = inflater;
    }

    public void setOnRetryClickListener(OnRetryClickListener listener) {
        this.mRetryClickListener = listener;
    }

    public static interface OnRetryClickListener {
        public void onRetryClick();
    }
}

