/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.stateview.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.github.nukc.stateview.AnimatorProvider;
import com.github.nukc.stateview.StateView;

public class SlideAnimatorProvider
implements AnimatorProvider {
    private StateView mStateView;

    public SlideAnimatorProvider(StateView view) {
        this.mStateView = view;
    }

    public Animator showAnimation() {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat(null, (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat(null, (String)"translationX", (float[])new float[]{this.getDistance(), 0.0f})});
        set.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        return set;
    }

    public Animator hideAnimation() {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat(null, (String)"alpha", (float[])new float[]{1.0f, 0.0f}), ObjectAnimator.ofFloat(null, (String)"translationX", (float[])new float[]{0.0f, this.getDistance()})});
        set.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        return set;
    }

    private float getDistance() {
        ViewParent viewParent = this.mStateView.getParent();
        if (viewParent == null) {
            return 0.0f;
        }
        return ((View)viewParent).getWidth();
    }
}

