/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.LoadMoreWrapper;

import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import com.github.nukc.LoadMoreWrapper.LoadMoreHelper;
import com.github.nukc.LoadMoreWrapper.R;
import java.util.List;

public class LoadMoreAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = LoadMoreAdapter.class.getSimpleName();
    private static final byte TYPE_FOOTER = -2;
    private static final byte TYPE_NO_MORE = -3;
    private RecyclerView.Adapter mAdapter;
    private View mFooterView;
    private int mFooterResId = -1;
    private View mNoMoreView;
    private int mNoMoreResId = -1;
    private RecyclerView mRecyclerView;
    private OnLoadMoreListener mOnLoadMoreListener;
    private Enabled mEnabled;
    private boolean mIsLoading;
    private boolean mShouldRemove;
    private boolean mShowNoMoreEnabled;
    private RecyclerView.OnScrollListener mOnScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (!LoadMoreAdapter.this.getLoadMoreEnabled() || LoadMoreAdapter.this.mIsLoading) {
                return;
            }
            if (newState == 0 && LoadMoreAdapter.this.mOnLoadMoreListener != null) {
                boolean isBottom;
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                if (layoutManager instanceof LinearLayoutManager) {
                    isBottom = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition() >= layoutManager.getItemCount() - 1;
                } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                    StaggeredGridLayoutManager sgLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                    int[] into = new int[sgLayoutManager.getSpanCount()];
                    sgLayoutManager.findLastVisibleItemPositions(into);
                    isBottom = LoadMoreAdapter.last(into) >= layoutManager.getItemCount() - 1;
                } else {
                    boolean bl = isBottom = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition() >= layoutManager.getItemCount() - 1;
                }
                if (isBottom) {
                    LoadMoreAdapter.this.mIsLoading = true;
                    LoadMoreAdapter.this.mOnLoadMoreListener.onLoadMore(LoadMoreAdapter.this.mEnabled);
                }
            }
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
        }
    };
    private OnEnabledListener mOnEnabledListener = new OnEnabledListener(){

        @Override
        public void notifyChanged() {
            LoadMoreAdapter.this.mShouldRemove = true;
        }
    };
    private RecyclerView.AdapterDataObserver mObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            if (LoadMoreAdapter.this.mShouldRemove) {
                LoadMoreAdapter.this.mShouldRemove = false;
            }
            LoadMoreAdapter.this.notifyDataSetChanged();
            LoadMoreAdapter.this.mIsLoading = false;
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            if (LoadMoreAdapter.this.mShouldRemove && positionStart == LoadMoreAdapter.this.mAdapter.getItemCount()) {
                LoadMoreAdapter.this.mShouldRemove = false;
            }
            LoadMoreAdapter.this.notifyItemRangeChanged(positionStart, itemCount);
            LoadMoreAdapter.this.mIsLoading = false;
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            if (LoadMoreAdapter.this.mShouldRemove && positionStart == LoadMoreAdapter.this.mAdapter.getItemCount()) {
                LoadMoreAdapter.this.mShouldRemove = false;
            }
            LoadMoreAdapter.this.notifyItemRangeChanged(positionStart, itemCount, payload);
            LoadMoreAdapter.this.mIsLoading = false;
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            if (LoadMoreAdapter.this.mRecyclerView.getChildCount() == 1) {
                LoadMoreAdapter.this.notifyItemRemoved(0);
            }
            LoadMoreAdapter.this.notifyItemRangeInserted(positionStart, itemCount);
            LoadMoreAdapter.this.notifyFooterHolderChanged();
            LoadMoreAdapter.this.mIsLoading = false;
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            if (LoadMoreAdapter.this.mShouldRemove && positionStart == LoadMoreAdapter.this.mAdapter.getItemCount()) {
                LoadMoreAdapter.this.mShouldRemove = false;
            }
            boolean shouldSync = false;
            if (LoadMoreAdapter.this.mEnabled.getLoadMoreEnabled() && LoadMoreAdapter.this.mAdapter.getItemCount() == 0) {
                LoadMoreAdapter.this.setLoadMoreEnabled(false);
                shouldSync = true;
                if (LoadMoreAdapter.this.getItemCount() == 1) {
                    LoadMoreAdapter.this.notifyItemRemoved(0);
                }
            }
            LoadMoreAdapter.this.notifyItemRangeRemoved(positionStart, itemCount);
            if (shouldSync) {
                LoadMoreAdapter.this.setLoadMoreEnabled(true);
            }
            LoadMoreAdapter.this.mIsLoading = false;
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            if (LoadMoreAdapter.this.mShouldRemove && (fromPosition == LoadMoreAdapter.this.mAdapter.getItemCount() || toPosition == LoadMoreAdapter.this.mAdapter.getItemCount())) {
                throw new IllegalArgumentException("can not move last position after setLoadMoreEnabled(false)");
            }
            LoadMoreAdapter.this.notifyItemMoved(fromPosition, toPosition);
            LoadMoreAdapter.this.mIsLoading = false;
        }
    };

    public LoadMoreAdapter(@NonNull RecyclerView.Adapter adapter) {
        this.registerAdapter(adapter);
    }

    public LoadMoreAdapter(@NonNull RecyclerView.Adapter adapter, View footerView) {
        this.registerAdapter(adapter);
        this.mFooterView = footerView;
    }

    public LoadMoreAdapter(@NonNull RecyclerView.Adapter adapter, @LayoutRes int resId) {
        this.registerAdapter(adapter);
        this.mFooterResId = resId;
    }

    private void registerAdapter(RecyclerView.Adapter adapter) {
        if (adapter == null) {
            throw new NullPointerException("adapter can not be null!");
        }
        this.mAdapter = adapter;
        this.mAdapter.registerAdapterDataObserver(this.mObserver);
        this.mEnabled = new Enabled(this.mOnEnabledListener);
    }

    public RecyclerView.Adapter getOriginalAdapter() {
        return this.mAdapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == -2) {
            if (this.mFooterResId != -1) {
                this.mFooterView = LoadMoreHelper.inflate(parent, this.mFooterResId);
            }
            if (this.mFooterView != null) {
                return new FooterHolder(this.mFooterView);
            }
            View view = LoadMoreHelper.inflate(parent, R.layout.base_footer);
            return new FooterHolder(view);
        }
        if (viewType == -3) {
            if (this.mNoMoreResId != -1) {
                this.mNoMoreView = LoadMoreHelper.inflate(parent, this.mNoMoreResId);
            }
            if (this.mNoMoreView != null) {
                return new NoMoreHolder(this.mNoMoreView);
            }
            View view = LoadMoreHelper.inflate(parent, R.layout.base_no_more);
            return new NoMoreHolder(view);
        }
        return this.mAdapter.onCreateViewHolder(parent, viewType);
    }

    public final void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        if (holder instanceof FooterHolder) {
            if (!this.canScroll() && this.mOnLoadMoreListener != null && !this.mIsLoading) {
                this.mIsLoading = true;
                this.mRecyclerView.post(new Runnable(){

                    @Override
                    public void run() {
                        LoadMoreAdapter.this.mOnLoadMoreListener.onLoadMore(LoadMoreAdapter.this.mEnabled);
                    }
                });
            }
        } else if (!(holder instanceof NoMoreHolder)) {
            this.mAdapter.onBindViewHolder(holder, position, payloads);
        }
    }

    public int getItemCount() {
        int count = this.mAdapter.getItemCount();
        return this.getLoadMoreEnabled() ? count + 1 : (this.mShowNoMoreEnabled ? count + 1 : count + (this.mShouldRemove ? 1 : 0));
    }

    public int getItemViewType(int position) {
        if (position == this.mAdapter.getItemCount() && (this.getLoadMoreEnabled() || this.mShouldRemove)) {
            return -2;
        }
        if (position == this.mAdapter.getItemCount() && this.mShowNoMoreEnabled && !this.getLoadMoreEnabled()) {
            return -3;
        }
        return this.mAdapter.getItemViewType(position);
    }

    public boolean canScroll() {
        if (this.mRecyclerView == null) {
            throw new NullPointerException("mRecyclerView is null, you should setAdapter(recyclerAdapter);");
        }
        return ViewCompat.canScrollVertically((View)this.mRecyclerView, (int)-1);
    }

    public void setFooterView(View footerView) {
        this.mFooterView = footerView;
    }

    public void setFooterView(@LayoutRes int resId) {
        this.mFooterResId = resId;
    }

    public void setNoMoreView(View noMoreView) {
        this.mNoMoreView = noMoreView;
    }

    public void setNoMoreView(@LayoutRes int resId) {
        this.mNoMoreResId = resId;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        recyclerView.addOnScrollListener(this.mOnScrollListener);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            final GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            final GridLayoutManager.SpanSizeLookup originalSizeLookup = gridLayoutManager.getSpanSizeLookup();
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    int itemViewType = LoadMoreAdapter.this.getItemViewType(position);
                    if (itemViewType == -2 || itemViewType == -3) {
                        return gridLayoutManager.getSpanCount();
                    }
                    if (originalSizeLookup != null) {
                        return originalSizeLookup.getSpanSize(position);
                    }
                    return 1;
                }
            });
        }
    }

    private static int last(int[] lastPositions) {
        int last = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= last) continue;
            last = value;
        }
        return last;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        recyclerView.removeOnScrollListener(this.mOnScrollListener);
        this.mAdapter.unregisterAdapterDataObserver(this.mObserver);
        this.mRecyclerView = null;
    }

    public void setLoadMoreListener(OnLoadMoreListener listener) {
        this.mOnLoadMoreListener = listener;
    }

    public void setLoadMoreEnabled(boolean enabled) {
        this.mEnabled.setLoadMoreEnabled(enabled);
    }

    public boolean getLoadMoreEnabled() {
        return this.mEnabled.getLoadMoreEnabled() && this.mAdapter.getItemCount() >= 0;
    }

    public void setShouldRemove(boolean shouldRemove) {
        this.mShouldRemove = shouldRemove;
    }

    public void setShowNoMoreEnabled(boolean showNoMoreEnabled) {
        this.mShowNoMoreEnabled = showNoMoreEnabled;
    }

    private void notifyFooterHolderChanged() {
        if (this.getLoadMoreEnabled()) {
            this.notifyItemChanged(this.mAdapter.getItemCount());
        } else if (this.mShouldRemove) {
            this.mShouldRemove = false;
            int position = this.mAdapter.getItemCount();
            RecyclerView.ViewHolder viewHolder = this.mRecyclerView.findViewHolderForAdapterPosition(position);
            if (viewHolder instanceof FooterHolder) {
                this.notifyItemRemoved(position);
            } else {
                this.notifyItemChanged(position);
            }
        }
    }

    public static class Enabled {
        private boolean mLoadMoreEnabled = true;
        private OnEnabledListener mListener;

        public Enabled(OnEnabledListener listener) {
            this.mListener = listener;
        }

        public void setLoadMoreEnabled(boolean enabled) {
            boolean canNotify = this.mLoadMoreEnabled;
            this.mLoadMoreEnabled = enabled;
            if (canNotify && !this.mLoadMoreEnabled) {
                this.mListener.notifyChanged();
            }
        }

        public boolean getLoadMoreEnabled() {
            return this.mLoadMoreEnabled;
        }
    }

    private static interface OnEnabledListener {
        public void notifyChanged();
    }

    public static interface OnLoadMoreListener {
        public void onLoadMore(Enabled var1);
    }

    static class NoMoreHolder
    extends RecyclerView.ViewHolder {
        public NoMoreHolder(View itemView) {
            super(itemView);
            LoadMoreHelper.setItemViewFullSpan(itemView);
        }
    }

    static class FooterHolder
    extends RecyclerView.ViewHolder {
        public FooterHolder(View itemView) {
            super(itemView);
            LoadMoreHelper.setItemViewFullSpan(itemView);
        }
    }
}

