/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.stateview;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.ScrollingView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.github.nukc.stateview.StateView;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/github/nukc/stateview/Injector;", "", "()V", "constraintLayoutAvailable", "", "getConstraintLayoutAvailable", "()Z", "swipeRefreshLayoutAvailable", "getSwipeRefreshLayoutAvailable", "injectIntoSwipeRefreshLayout", "", "layout", "Landroidx/swiperefreshlayout/widget/SwipeRefreshLayout;", "matchViewIfParentIsConstraintLayout", "Lcom/github/nukc/stateview/StateView;", "parent", "Landroidx/constraintlayout/widget/ConstraintLayout;", "view", "Landroid/view/View;", "matchViewIfParentIsRelativeLayout", "Landroid/widget/RelativeLayout;", "setStateListAnimator", "stateView", "target", "wrapChild", "Landroid/view/ViewGroup;", "kotlin_release"})
public final class Injector {
    @NotNull
    public static final Injector INSTANCE;
    private static final boolean constraintLayoutAvailable;
    private static final boolean swipeRefreshLayoutAvailable;

    private Injector() {
    }

    public final boolean getConstraintLayoutAvailable() {
        return constraintLayoutAvailable;
    }

    public final boolean getSwipeRefreshLayoutAvailable() {
        return swipeRefreshLayoutAvailable;
    }

    @NotNull
    public final StateView wrapChild(@NotNull ViewGroup parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int screenHeight = 0;
        FrameLayout wrapper = new FrameLayout(parent.getContext());
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        wrapper.setLayoutParams(layoutParams);
        if (parent instanceof LinearLayout) {
            LinearLayout wrapLayout = new LinearLayout(((LinearLayout)parent).getContext());
            ViewGroup.LayoutParams layoutParams2 = ((LinearLayout)parent).getLayoutParams();
            wrapLayout.setLayoutParams(layoutParams2 == null ? layoutParams : layoutParams2);
            wrapLayout.setOrientation(((LinearLayout)parent).getOrientation());
            int i = 0;
            int childCount = parent.getChildCount();
            while (i < childCount) {
                View view = parent.getChildAt(0);
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"parent.getChildAt(0)");
                View childView = view;
                parent.removeView(childView);
                wrapLayout.addView(childView);
                int n = i;
                i = n + 1;
            }
            wrapper.addView((View)wrapLayout);
        } else if (parent instanceof ScrollView || parent instanceof ScrollingView) {
            if (parent.getChildCount() != 1) {
                throw new IllegalStateException("the ScrollView does not have one direct child");
            }
            View directView = parent.getChildAt(0);
            parent.removeView(directView);
            wrapper.addView(directView);
            Object childCount = parent.getContext().getSystemService("window");
            if (childCount == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager wm = (WindowManager)childCount;
            DisplayMetrics metrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(metrics);
            screenHeight = metrics.heightPixels;
        } else if (parent instanceof NestedScrollingParent && parent instanceof NestedScrollingChild) {
            if (parent.getChildCount() == 2) {
                View targetView = parent.getChildAt(1);
                parent.removeView(targetView);
                wrapper.addView(targetView);
            } else if (parent.getChildCount() > 2) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"the view is not refresh layout? view = ", (Object)parent));
            }
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"the view does not have parent, view = ", (Object)parent));
        }
        parent.addView((View)wrapper);
        Context wm = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)wm, (String)"parent.context");
        StateView stateView = new StateView(wm, null, 0, 6, null);
        if (screenHeight > 0) {
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, screenHeight);
            wrapper.addView((View)stateView, params);
        } else {
            wrapper.addView((View)stateView);
        }
        return stateView;
    }

    @NotNull
    public final StateView matchViewIfParentIsConstraintLayout(@NotNull ConstraintLayout parent, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"parent.context");
        StateView stateView = new StateView(context, null, 0, 6, null);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }
        ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(layoutParams);
        lp.leftToLeft = view.getId();
        lp.rightToRight = view.getId();
        lp.topToTop = view.getId();
        lp.bottomToBottom = view.getId();
        parent.addView((View)stateView, (ViewGroup.LayoutParams)lp);
        return stateView;
    }

    @NotNull
    public final StateView matchViewIfParentIsRelativeLayout(@NotNull RelativeLayout parent, @NotNull View view) {
        RelativeLayout.LayoutParams layoutParams;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"parent.context");
        StateView stateView = new StateView(context, null, 0, 6, null);
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup.LayoutParams layoutParams2 = view.getLayoutParams();
            if (layoutParams2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            }
            RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams((RelativeLayout.LayoutParams)layoutParams2);
            layoutParams = layoutParams3;
        } else {
            layoutParams = new RelativeLayout.LayoutParams(view.getLayoutParams());
        }
        RelativeLayout.LayoutParams lp = layoutParams;
        parent.addView((View)stateView, (ViewGroup.LayoutParams)lp);
        this.setStateListAnimator(stateView, view);
        return stateView;
    }

    public final void setStateListAnimator(@NotNull StateView stateView, @NotNull View target) {
        Intrinsics.checkNotNullParameter((Object)((Object)stateView), (String)"stateView");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (Build.VERSION.SDK_INT >= 21 && target instanceof Button) {
            Log.i((String)"StateView", (String)"for normal display, stateView.stateListAnimator = view.stateListAnimator");
            stateView.setStateListAnimator(((Button)target).getStateListAnimator());
        }
    }

    public final void injectIntoSwipeRefreshLayout(@NotNull SwipeRefreshLayout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        try {
            Field mTargetField = SwipeRefreshLayout.class.getDeclaredField("mTarget");
            mTargetField.setAccessible(true);
            mTargetField.set(layout, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        boolean bl;
        INSTANCE = new Injector();
        try {
            bl = Class.forName("androidx.constraintlayout.widget.ConstraintLayout") != null;
        }
        catch (Throwable e) {
            bl = false;
        }
        constraintLayoutAvailable = bl;
        try {
            bl = Class.forName("androidx.swiperefreshlayout.widget.SwipeRefreshLayout") != null;
        }
        catch (Throwable e) {
            bl = false;
        }
        swipeRefreshLayoutAvailable = bl;
    }
}

