/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.stateview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import androidx.annotation.LayoutRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.ScrollingView;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.FragmentContainerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.github.nukc.stateview.AnimatorProvider;
import com.github.nukc.stateview.Injector;
import com.github.nukc.stateview.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 J2\u00020\u0001:\u0003JKLB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010/\u001a\u00020\u00012\b\b\u0001\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0001H\u0002J\u0012\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107H\u0014J\u0012\u00108\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107H\u0017J\u0010\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020\u0001H\u0002J\u0012\u0010;\u001a\u00020\u00012\b\b\u0001\u00100\u001a\u00020\u0007H\u0002J\u0018\u0010<\u001a\u0002052\u0006\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\u0007H\u0014J\u0012\u0010?\u001a\u0002052\b\u00103\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010@\u001a\u0002052\u0006\u0010A\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0001J\u001a\u0010B\u001a\u0002052\b\u00103\u001a\u0004\u0018\u00010\u00012\u0006\u0010C\u001a\u00020\u0007H\u0002J\u0010\u0010B\u001a\u0002052\u0006\u0010C\u001a\u00020\u0007H\u0016J\u000e\u0010D\u001a\u00020\u00012\u0006\u0010A\u001a\u00020\u0007J\u0006\u0010E\u001a\u000205J\u0006\u0010F\u001a\u00020\u0001J\u0006\u0010G\u001a\u00020\u0001J\u0006\u0010H\u001a\u00020\u0001J\u0012\u0010:\u001a\u00020\u00012\b\b\u0001\u00100\u001a\u00020\u0007H\u0002J\u0010\u0010I\u001a\u0002052\u0006\u00103\u001a\u00020\u0001H\u0002R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001e\u0010*\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0012\"\u0004\b,\u0010\u0014R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00010.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/github/nukc/stateview/StateView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "Lcom/github/nukc/stateview/AnimatorProvider;", "animatorProvider", "getAnimatorProvider", "()Lcom/github/nukc/stateview/AnimatorProvider;", "setAnimatorProvider", "(Lcom/github/nukc/stateview/AnimatorProvider;)V", "emptyResource", "getEmptyResource", "()I", "setEmptyResource", "(I)V", "inflater", "Landroid/view/LayoutInflater;", "getInflater", "()Landroid/view/LayoutInflater;", "setInflater", "(Landroid/view/LayoutInflater;)V", "loadingResource", "getLoadingResource", "setLoadingResource", "onInflateListener", "Lcom/github/nukc/stateview/StateView$OnInflateListener;", "getOnInflateListener", "()Lcom/github/nukc/stateview/StateView$OnInflateListener;", "setOnInflateListener", "(Lcom/github/nukc/stateview/StateView$OnInflateListener;)V", "onRetryClickListener", "Lcom/github/nukc/stateview/StateView$OnRetryClickListener;", "getOnRetryClickListener", "()Lcom/github/nukc/stateview/StateView$OnRetryClickListener;", "setOnRetryClickListener", "(Lcom/github/nukc/stateview/StateView$OnRetryClickListener;)V", "retryResource", "getRetryResource", "setRetryResource", "views", "Landroid/util/SparseArray;", "addToParent", "layoutResource", "viewParent", "Landroid/view/ViewGroup;", "view", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "draw", "hideViews", "showView", "inflate", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "reset", "setView", "viewType", "setVisibility", "visibility", "show", "showContent", "showEmpty", "showLoading", "showRetry", "startAnimation", "Companion", "OnInflateListener", "OnRetryClickListener", "kotlin_release"})
public final class StateView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SparseArray<View> views;
    @LayoutRes
    private int emptyResource;
    @LayoutRes
    private int retryResource;
    @LayoutRes
    private int loadingResource;
    @Nullable
    private LayoutInflater inflater;
    @Nullable
    private OnRetryClickListener onRetryClickListener;
    @Nullable
    private OnInflateListener onInflateListener;
    @Nullable
    private AnimatorProvider animatorProvider;
    @NotNull
    public static final String TAG = "StateView";

    @JvmOverloads
    public StateView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.views = new SparseArray(3);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.StateView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttributes(attrs, R.styleable.StateView)");
        TypedArray a = typedArray;
        this.emptyResource = a.getResourceId(R.styleable.StateView_emptyResource, 0);
        this.retryResource = a.getResourceId(R.styleable.StateView_retryResource, 0);
        this.loadingResource = a.getResourceId(R.styleable.StateView_loadingResource, 0);
        a.recycle();
        if (this.emptyResource == 0) {
            this.emptyResource = R.layout.base_empty;
        }
        if (this.retryResource == 0) {
            this.retryResource = R.layout.base_retry;
        }
        if (this.loadingResource == 0) {
            this.loadingResource = R.layout.base_loading;
        }
        this.setVisibility(8);
        this.setWillNotDraw(true);
    }

    public /* synthetic */ StateView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getEmptyResource() {
        return this.emptyResource;
    }

    public final void setEmptyResource(int n) {
        this.emptyResource = n;
    }

    public final int getRetryResource() {
        return this.retryResource;
    }

    public final void setRetryResource(int n) {
        this.retryResource = n;
    }

    public final int getLoadingResource() {
        return this.loadingResource;
    }

    public final void setLoadingResource(int n) {
        this.loadingResource = n;
    }

    @Nullable
    public final LayoutInflater getInflater() {
        return this.inflater;
    }

    public final void setInflater(@Nullable LayoutInflater layoutInflater) {
        this.inflater = layoutInflater;
    }

    @Nullable
    public final OnRetryClickListener getOnRetryClickListener() {
        return this.onRetryClickListener;
    }

    public final void setOnRetryClickListener(@Nullable OnRetryClickListener onRetryClickListener) {
        this.onRetryClickListener = onRetryClickListener;
    }

    @Nullable
    public final OnInflateListener getOnInflateListener() {
        return this.onInflateListener;
    }

    public final void setOnInflateListener(@Nullable OnInflateListener onInflateListener) {
        this.onInflateListener = onInflateListener;
    }

    @Nullable
    public final AnimatorProvider getAnimatorProvider() {
        return this.animatorProvider;
    }

    public final void setAnimatorProvider(@Nullable AnimatorProvider value) {
        this.animatorProvider = value;
        int n = 0;
        int n2 = this.views.size();
        if (n < n2) {
            do {
                int i = n++;
                this.reset((View)this.views.valueAt(i));
            } while (n < n2);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(0, 0);
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void draw(@Nullable Canvas canvas) {
    }

    protected void dispatchDraw(@Nullable Canvas canvas) {
    }

    public void setVisibility(int visibility) {
        int n = 0;
        int n2 = this.views.size();
        if (n < n2) {
            do {
                int i = n++;
                this.setVisibility((View)this.views.valueAt(i), visibility);
            } while (n < n2);
        }
    }

    private final void setVisibility(View view, int visibility) {
        if (view != null && visibility != view.getVisibility()) {
            if (this.animatorProvider != null) {
                this.startAnimation(view);
            } else {
                view.setVisibility(visibility);
            }
        }
    }

    public final void setView(int viewType, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.views.put(viewType, (Object)view);
    }

    public final void showContent() {
        this.setVisibility(8);
    }

    @NotNull
    public final View showEmpty() {
        return this.showView(this.emptyResource);
    }

    @NotNull
    public final View showRetry() {
        return this.showView(this.retryResource);
    }

    @NotNull
    public final View showLoading() {
        return this.showView(this.loadingResource);
    }

    @NotNull
    public final View show(int viewType) {
        return this.showView(viewType);
    }

    private final View showView(@LayoutRes int layoutResource) {
        ViewParent viewParent;
        View view = (View)this.views.get(layoutResource);
        if (view == null) {
            view = this.inflate(layoutResource);
            this.views.put(layoutResource, (Object)view);
        } else {
            viewParent = this.getParent();
            if (viewParent == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            if (((ViewGroup)viewParent).indexOfChild(view) == -1) {
                viewParent = this.getParent();
                if (viewParent == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                }
                ViewGroup viewGroup = (ViewGroup)viewParent;
                viewParent = view;
                this.addToParent(layoutResource, viewGroup, (View)viewParent);
            }
        }
        this.setVisibility(view, 0);
        viewParent = view;
        Intrinsics.checkNotNullExpressionValue((Object)viewParent, (String)"view");
        this.hideViews((View)viewParent);
        viewParent = view;
        Intrinsics.checkNotNullExpressionValue((Object)viewParent, (String)"view");
        return viewParent;
    }

    private final void hideViews(View showView) {
        int n = 0;
        int n2 = this.views.size();
        if (n < n2) {
            do {
                int i;
                View view;
                if (Intrinsics.areEqual((Object)(view = (View)this.views.valueAt(i = n++)), (Object)showView)) continue;
                this.setVisibility(view, 8);
            } while (n < n2);
        }
    }

    private final void startAnimation(View view) {
        block4: {
            AnimatorProvider animatorProvider;
            boolean bl;
            AnimatorProvider animatorProvider2;
            Object object;
            Animator animator;
            AnimatorProvider animatorProvider3;
            boolean toShow;
            boolean bl2 = toShow = view.getVisibility() == 8;
            if (toShow) {
                animatorProvider3 = this.animatorProvider;
                Intrinsics.checkNotNull((Object)animatorProvider3);
                animator = animatorProvider3.showAnimation(view);
            } else {
                animatorProvider3 = this.animatorProvider;
                Intrinsics.checkNotNull((Object)animatorProvider3);
                animator = object = animatorProvider3.hideAnimation(view);
            }
            if (object == null) {
                animatorProvider2 = null;
            } else {
                animatorProvider3 = object;
                bl = false;
                boolean bl3 = false;
                AnimatorProvider $this$startAnimation_u24lambda_u2d0 = animatorProvider3;
                boolean bl4 = false;
                $this$startAnimation_u24lambda_u2d0.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(toShow, view){
                    final /* synthetic */ boolean $toShow;
                    final /* synthetic */ View $view;
                    {
                        this.$toShow = $toShow;
                        this.$view = $view;
                    }

                    public void onAnimationEnd(@NotNull Animator animation) {
                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                        super.onAnimationEnd(animation);
                        if (!this.$toShow) {
                            this.$view.setVisibility(8);
                        }
                    }

                    public void onAnimationStart(@NotNull Animator animation) {
                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                        super.onAnimationStart(animation);
                        if (this.$toShow) {
                            this.$view.setVisibility(0);
                        }
                    }
                });
                $this$startAnimation_u24lambda_u2d0.start();
                animatorProvider2 = animatorProvider = animatorProvider3;
            }
            if (animatorProvider != null) break block4;
            object = this;
            boolean bl5 = false;
            bl = false;
            StateView it = (StateView)((Object)object);
            boolean bl6 = false;
            view.setVisibility(toShow ? 0 : 8);
        }
    }

    private final void reset(View view) {
        if (view != null) {
            view.setTranslationX(0.0f);
            view.setTranslationY(0.0f);
            view.setAlpha(1.0f);
            view.setRotation(0.0f);
            view.setScaleX(1.0f);
            view.setScaleY(1.0f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final View inflate(@LayoutRes int layoutResource) {
        LayoutInflater layoutInflater;
        ViewParent viewParent = this.getParent();
        if (!(viewParent instanceof ViewGroup)) throw new IllegalStateException("StateView must have a non-null ViewGroup viewParent");
        if (layoutResource == 0) throw new IllegalArgumentException("StateView must have a valid layoutResource");
        LayoutInflater layoutInflater2 = this.inflater;
        if (layoutInflater2 == null) {
            LayoutInflater layoutInflater3 = LayoutInflater.from((Context)this.getContext());
            Intrinsics.checkNotNullExpressionValue((Object)layoutInflater3, (String)"from(context)");
            layoutInflater = layoutInflater3;
        } else {
            layoutInflater = layoutInflater2;
        }
        LayoutInflater factory = layoutInflater;
        View view = factory.inflate(layoutResource, (ViewGroup)viewParent, false);
        ViewGroup viewGroup = (ViewGroup)viewParent;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
        return this.addToParent(layoutResource, viewGroup, view);
    }

    private final View addToParent(@LayoutRes int layoutResource, ViewGroup viewParent, View view) {
        OnInflateListener onInflateListener;
        int index = viewParent.indexOfChild((View)this);
        view.setClickable(true);
        view.setVisibility(8);
        ViewCompat.setZ((View)view, (float)ViewCompat.getZ((View)this));
        if (this.getLayoutParams() != null) {
            if (viewParent instanceof RelativeLayout) {
                RelativeLayout.LayoutParams layoutParams;
                if (Build.VERSION.SDK_INT >= 19) {
                    ViewGroup.LayoutParams layoutParams2 = this.getLayoutParams();
                    if (layoutParams2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
                    }
                    RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams((RelativeLayout.LayoutParams)layoutParams2);
                    layoutParams = layoutParams3;
                } else {
                    layoutParams = new RelativeLayout.LayoutParams(this.getLayoutParams());
                }
                RelativeLayout.LayoutParams lp = layoutParams;
                viewParent.addView(view, index, (ViewGroup.LayoutParams)lp);
            } else if (Injector.INSTANCE.getConstraintLayoutAvailable() && viewParent instanceof ConstraintLayout) {
                ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                }
                ConstraintLayout.LayoutParams source = (ConstraintLayout.LayoutParams)layoutParams;
                ViewGroup.LayoutParams layoutParams4 = this.getLayoutParams();
                if (layoutParams4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
                }
                ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(layoutParams4);
                lp.leftToLeft = source.leftToLeft;
                lp.rightToRight = source.rightToRight;
                lp.topToTop = source.topToTop;
                lp.bottomToBottom = source.bottomToBottom;
                viewParent.addView(view, index, (ViewGroup.LayoutParams)lp);
            } else {
                viewParent.addView(view, index, this.getLayoutParams());
            }
        } else {
            viewParent.addView(view, index);
        }
        if (layoutResource == this.retryResource) {
            view.setOnClickListener(arg_0 -> StateView.addToParent$lambda-4(this, view, arg_0));
        }
        if ((onInflateListener = this.onInflateListener) != null) {
            onInflateListener.onInflate(layoutResource, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
    }

    @JvmOverloads
    public StateView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StateView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void addToParent$lambda-4$lambda-3$lambda-2(OnRetryClickListener $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        $it.onRetryClick();
    }

    private static final void addToParent$lambda-4(StateView this$0, View $view, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        OnRetryClickListener onRetryClickListener = this$0.getOnRetryClickListener();
        if (onRetryClickListener != null) {
            OnRetryClickListener onRetryClickListener2 = onRetryClickListener;
            boolean bl = false;
            boolean bl2 = false;
            OnRetryClickListener it2 = onRetryClickListener2;
            boolean bl3 = false;
            this$0.showLoading();
            $view.postDelayed(() -> StateView.addToParent$lambda-4$lambda-3$lambda-2(it2), 400L);
        }
    }

    @JvmStatic
    @NotNull
    public static final StateView inject(@NotNull Activity activity) {
        return Companion.inject(activity);
    }

    @JvmStatic
    @NotNull
    public static final StateView inject(@NotNull View view) {
        return Companion.inject(view);
    }

    @JvmStatic
    @NotNull
    public static final StateView inject(@NotNull ViewGroup viewGroup) {
        return Companion.inject(viewGroup);
    }

    @JvmStatic
    @NotNull
    public static final StateView wrap(@NotNull View view) {
        return Companion.wrap(view);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/github/nukc/stateview/StateView$OnRetryClickListener;", "", "onRetryClick", "", "kotlin_release"})
    public static interface OnRetryClickListener {
        public void onRetryClick();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/github/nukc/stateview/StateView$OnInflateListener;", "", "onInflate", "", "layoutResource", "", "view", "Landroid/view/View;", "kotlin_release"})
    public static interface OnInflateListener {
        public void onInflate(@LayoutRes int var1, @NotNull View var2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/nukc/stateview/StateView$Companion;", "", "()V", "TAG", "", "inject", "Lcom/github/nukc/stateview/StateView;", "activity", "Landroid/app/Activity;", "view", "Landroid/view/View;", "viewGroup", "Landroid/view/ViewGroup;", "wrap", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final StateView inject(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            View view = activity.getWindow().getDecorView().findViewById(0x1020002);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView.findViewById<View>(android.R.id.content)");
            return this.inject(view);
        }

        @JvmStatic
        @NotNull
        public final StateView inject(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            View view2 = view;
            return view2 instanceof ViewGroup ? this.inject((ViewGroup)view) : this.wrap(view);
        }

        @JvmStatic
        @NotNull
        public final StateView inject(@NotNull ViewGroup viewGroup) {
            Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
            if (viewGroup instanceof LinearLayout || viewGroup instanceof ScrollView || viewGroup instanceof AdapterView || viewGroup instanceof ScrollingView && viewGroup instanceof NestedScrollingChild || viewGroup instanceof NestedScrollingParent && viewGroup instanceof NestedScrollingChild) {
                return viewGroup.getParent() instanceof ViewGroup && !(viewGroup.getParent() instanceof FragmentContainerView) ? this.wrap((View)viewGroup) : Injector.INSTANCE.wrapChild(viewGroup);
            }
            Context context = viewGroup.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"viewGroup.context");
            StateView stateView = new StateView(context, null, 0, 6, null);
            viewGroup.addView((View)stateView, -1, -1);
            return stateView;
        }

        @JvmStatic
        @NotNull
        public final StateView wrap(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            ViewParent parent = view.getParent();
            if (parent instanceof ViewGroup) {
                if (Injector.INSTANCE.getConstraintLayoutAvailable() && parent instanceof ConstraintLayout) {
                    return Injector.INSTANCE.matchViewIfParentIsConstraintLayout((ConstraintLayout)parent, view);
                }
                if (parent instanceof RelativeLayout) {
                    return Injector.INSTANCE.matchViewIfParentIsRelativeLayout((RelativeLayout)parent, view);
                }
                ((ViewGroup)parent).removeView(view);
                FrameLayout wrap = new FrameLayout(view.getContext());
                ((ViewGroup)parent).addView((View)wrap, view.getLayoutParams());
                wrap.addView(view, -1, -1);
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
                StateView stateView = new StateView(context, null, 0, 6, null);
                wrap.addView((View)stateView, -1, -1);
                Injector.INSTANCE.setStateListAnimator(stateView, view);
                if (Injector.INSTANCE.getSwipeRefreshLayoutAvailable() && parent instanceof SwipeRefreshLayout) {
                    Injector.INSTANCE.injectIntoSwipeRefreshLayout((SwipeRefreshLayout)parent);
                }
                return stateView;
            }
            throw new ClassCastException("view.getParent() must be ViewGroup");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

