/*
 * Decompiled with CFR 0.152.
 */
package norswap.utils.multi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import norswap.utils.Pair;

public interface MultiMap<K, V>
extends Map<K, Collection<V>> {
    @Override
    public Collection<V> get(Object var1);

    @Override
    public Collection<V> remove(Object var1);

    public Collection<V> add(K var1, V var2);

    public Collection<V> delete(K var1, V var2);

    public Collection<V> delete_pollute(K var1, V var2);

    public Collection<V> add_all(K var1, V[] var2);

    public Collection<V> add_all(K var1, Iterable<V> var2);

    default public Collection<V> add_all(K key, Collection<V> values) {
        return this.add_all(key, (Iterable<V>)values);
    }

    default public Collection<V> all_values() {
        ArrayList out = new ArrayList();
        for (Collection col : this.values()) {
            out.addAll(col);
        }
        return out;
    }

    default public void add(Map<K, V> single_map) {
        for (Map.Entry<K, V> e : single_map.entrySet()) {
            this.add(e.getKey(), e.getValue());
        }
    }

    default public void add(MultiMap<K, V> multi_map) {
        for (Map.Entry e : multi_map.entrySet()) {
            this.add_all(e.getKey(), (Collection)e.getValue());
        }
    }

    default public <X> MultiMap<K, V> assoc(Iterable<X> items, Function<X, Pair<K, V>> f) {
        for (X item : items) {
            Pair<K, V> pair = f.apply(item);
            if (pair == null) continue;
            this.add(pair.a, pair.b);
        }
        return this;
    }

    default public <X> MultiMap<K, V> assoc(X[] items, Function<X, Pair<K, V>> f) {
        for (X item : items) {
            Pair<K, V> pair = f.apply(item);
            if (pair == null) continue;
            this.add(pair.a, pair.b);
        }
        return this;
    }
}

