/*
 * Decompiled with CFR 0.152.
 */
package norswap.utils.multi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import norswap.utils.multi.MultiMap;

abstract class AbstractMultiHashMap<K, V>
extends HashMap<K, Collection<V>>
implements MultiMap<K, V> {
    AbstractMultiHashMap() {
    }

    abstract Collection<V> new_collection();

    abstract Collection<V> empty_collection();

    @Override
    public Collection<V> get(Object key) {
        Collection out = (Collection)super.get(key);
        return out == null ? this.empty_collection() : Collections.unmodifiableCollection(out);
    }

    @Override
    public Collection<V> remove(Object key) {
        Collection out = (Collection)super.remove(key);
        return out == null ? this.empty_collection() : Collections.unmodifiableCollection(out);
    }

    @Override
    public Collection<V> add(K key, V value) {
        Collection out = this.computeIfAbsent(key, k -> this.new_collection());
        out.add(value);
        return out;
    }

    @Override
    public Collection<V> delete(K key, V value) {
        Collection out = (Collection)super.get(key);
        if (out == null) {
            return this.empty_collection();
        }
        out.remove(value);
        return out.isEmpty() ? this.remove(key) : Collections.unmodifiableCollection(out);
    }

    @Override
    public Collection<V> delete_pollute(K key, V value) {
        Collection out = (Collection)super.get(key);
        if (out == null) {
            return this.empty_collection();
        }
        out.remove(value);
        return Collections.unmodifiableCollection(out);
    }

    @Override
    public Collection<V> add_all(K key, V[] values) {
        Collection out = this.computeIfAbsent(key, k -> this.new_collection());
        Collections.addAll(out, values);
        return out;
    }

    @Override
    public Collection<V> add_all(K key, Iterable<V> values) {
        Collection out = this.computeIfAbsent(key, k -> this.new_collection());
        for (V v : values) {
            out.add(v);
        }
        return out;
    }

    @Override
    public Collection<V> add_all(K key, Collection<V> values) {
        Collection out = this.computeIfAbsent(key, k -> this.new_collection());
        out.addAll(values);
        return out;
    }
}

