/*
 * Decompiled with CFR 0.152.
 */
package norswap.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Stream;
import norswap.utils.NArrays;
import norswap.utils.Util;

public final class Vanilla {
    public static <T> T last(List<T> list) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        return list.get(list.size() - 1);
    }

    public static <T> T last_or_null(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(list.size() - 1);
    }

    public static <T> void remove_last(List<T> list) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        list.remove(list.size() - 1);
    }

    public static <T> void remove_last(List<T> list, int n) {
        if (list.size() < n) {
            throw new NoSuchElementException();
        }
        for (int i = 0; i < n; ++i) {
            list.remove(list.size() - 1);
        }
    }

    @SafeVarargs
    public static <T> ArrayList<T> list(T ... items) {
        ArrayList out = new ArrayList(items.length);
        Collections.addAll(out, items);
        return out;
    }

    @SafeVarargs
    public static <T> HashSet<T> set(T ... items) {
        HashSet out = new HashSet(items.length);
        Collections.addAll(out, items);
        return out;
    }

    public static void pop(StringBuilder b, int n) {
        if (b.length() < n) {
            throw new NoSuchElementException();
        }
        b.replace(b.length() - n, b.length(), "");
    }

    @SafeVarargs
    public static <T> void add_array(Collection<T> col, T ... items) {
        col.addAll(Arrays.asList(items));
    }

    public static <T> void add_all(Collection<T> col, Iterable<T> items) {
        if (items instanceof Collection) {
            col.addAll((Collection)items);
        } else {
            items.forEach(col::add);
        }
    }

    public static ArrayList<Object> concat(Object ... items) {
        return Vanilla.concat_into(new ArrayList(), items);
    }

    public static <T extends Collection<Object>> T concat_into(T col, Object ... items) {
        for (Object item : items) {
            if (item instanceof Object[]) {
                Vanilla.add_array(col, items);
                continue;
            }
            if (item instanceof Iterable) {
                Vanilla.add_all(col, (Iterable)Util.cast(item));
                continue;
            }
            if (item instanceof Enumeration) {
                col.addAll(Collections.list((Enumeration)item));
                continue;
            }
            if (item instanceof Stream) {
                ((Stream)item).forEachOrdered(col::add);
                continue;
            }
            col.add((Object)item);
        }
        return col;
    }

    public static <T, R> ArrayList<R> map(Collection<T> collection, Function<T, R> f) {
        ArrayList<R> out = new ArrayList<R>(collection.size());
        for (T it : collection) {
            out.add(f.apply(it));
        }
        return out;
    }

    public static <T, R> ArrayList<R> map(Iterable<T> iterable, Function<T, R> f) {
        ArrayList<R> out = new ArrayList<R>();
        for (T it : iterable) {
            out.add(f.apply(it));
        }
        return out;
    }

    public static <T, R> R[] map(Collection<T> collection, R[] witness, Function<T, R> f) {
        R[] out = Arrays.copyOf(witness, collection.size());
        int i = 0;
        for (T item : collection) {
            out[i++] = f.apply(item);
        }
        return out;
    }

    public static <T, R> R[] map(Iterable<T> iterable, R[] witness, Function<T, R> f) {
        return Vanilla.map(iterable, f).toArray(witness);
    }

    public static <T, R> ArrayList<R> map(T[] array, Function<T, R> f) {
        ArrayList<R> out = new ArrayList<R>();
        for (T it : array) {
            out.add(f.apply(it));
        }
        return out;
    }

    public static <T, R> R[] map(T[] array, R[] witness, Function<T, R> f) {
        return NArrays.map(array, witness, f);
    }

    private static void check_deque_size(Deque<?> deque, int amount) {
        if (amount < 0 || deque.size() < amount) {
            throw new IndexOutOfBoundsException("amount (" + amount + ") too large for eque of size (" + deque.size() + ")");
        }
    }

    public static <T> T peek_index(Deque<T> deque, int depth) {
        Vanilla.check_deque_size(deque, depth + 1);
        int i = 0;
        for (T it : deque) {
            if (i++ != depth) continue;
            return it;
        }
        throw new Error();
    }

    public static <T> T[] peek(Deque<T> deque, int amount) {
        Vanilla.check_deque_size(deque, amount);
        Object[] args = new Object[amount];
        int i = 1;
        for (T it : deque) {
            if (i > amount) break;
            args[amount - i++] = it;
        }
        return args;
    }

    public static <T> T[] peek_from(Deque<T> deque, int index) {
        return Vanilla.peek(deque, deque.size() - index);
    }

    public static <T> T[] pop(Deque<T> deque, int amount) {
        Vanilla.check_deque_size(deque, amount);
        Object[] args = new Object[amount];
        for (int i = 1; i <= amount; ++i) {
            args[amount - i] = deque.pop();
        }
        return args;
    }

    public static <T> T[] pop_from(Deque<T> deque, int index) {
        return Vanilla.pop(deque, deque.size() - index);
    }
}

