/*
 * Decompiled with CFR 0.152.
 */
package norswap.utils;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public final class IO {
    public static String slurp(String file) {
        try {
            return new String(Files.readAllBytes(Paths.get(file, new String[0])));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List<Path> glob(String pattern, Path directory) throws IOException {
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        final ArrayList<Path> result = new ArrayList<Path>();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (matcher.matches(file)) {
                    result.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }
}

