/*
 * Decompiled with CFR 0.152.
 */
package norswap.utils;

import java.util.NoSuchElementException;
import norswap.utils.NArrays;
import norswap.utils.Strings;

public final class ArrayListLong
implements Cloneable {
    private long[] array;
    private int size;

    public ArrayListLong(int capacity) {
        this.array = new long[capacity];
    }

    public ArrayListLong() {
        this(8);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.array.length;
    }

    public long[] array() {
        return this.array;
    }

    public void set(int i, long v) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.array[i] = v;
    }

    public long get(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[i];
    }

    public void add(long v) {
        if (this.array.length < this.size + 1) {
            this.array = NArrays.resize_binary_power(this.array, this.size + 1);
        }
        this.array[this.size++] = v;
    }

    public void push(long item) {
        this.add(item);
    }

    public final void push(long ... items) {
        for (long item : items) {
            this.add(item);
        }
    }

    public long pop() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.array[--this.size];
    }

    public void pop(int n) {
        if (this.size < n) {
            throw new NoSuchElementException();
        }
        this.size -= n;
    }

    public long peek() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.array[this.size - 1];
    }

    public long back(int n) {
        if (this.size() <= n) {
            throw new NoSuchElementException();
        }
        return this.array[this.size - 1 - n];
    }

    public ArrayListLong clone() {
        try {
            ArrayListLong out = (ArrayListLong)super.clone();
            out.array = (long[])this.array.clone();
            out.size = this.size;
            return out;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            b.append(this.array[i]).append(", ");
        }
        if (b.length() > 1) {
            Strings.pop(b, 2);
        }
        b.append("]");
        return b.toString();
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            hashCode = 31 * hashCode + i;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayListLong)) {
            return false;
        }
        ArrayListLong other = (ArrayListLong)o;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == other.array[i]) continue;
            return false;
        }
        return true;
    }
}

