/*
 * Decompiled with CFR 0.152.
 */
package norswap.utils;

import java.util.NoSuchElementException;
import norswap.utils.NArrays;
import norswap.utils.Strings;

public final class ArrayListInt
implements Cloneable {
    private int[] array;
    private int size;

    public ArrayListInt(int capacity) {
        this.array = new int[capacity];
    }

    public ArrayListInt() {
        this(8);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.array.length;
    }

    public int[] array() {
        return this.array;
    }

    public void set(int i, int v) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.array[i] = v;
    }

    public int get(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[i];
    }

    public void add(int v) {
        if (this.array.length < this.size + 1) {
            this.array = NArrays.resize_binary_power(this.array, this.size + 1);
        }
        this.array[this.size++] = v;
    }

    public void push(int item) {
        this.add(item);
    }

    public final void push(int ... items) {
        for (int item : items) {
            this.add(item);
        }
    }

    public int pop() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.array[--this.size];
    }

    public void pop(int n) {
        if (this.size < n) {
            throw new NoSuchElementException();
        }
        this.size -= n;
    }

    public int peek() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.array[this.size - 1];
    }

    public int back(int n) {
        if (this.size() <= n) {
            throw new NoSuchElementException();
        }
        return this.array[this.size - 1 - n];
    }

    public ArrayListInt clone() {
        try {
            ArrayListInt out = (ArrayListInt)super.clone();
            out.array = (int[])this.array.clone();
            out.size = this.size;
            return out;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            b.append(this.array[i]).append(", ");
        }
        if (b.length() > 1) {
            Strings.pop(b, 2);
        }
        b.append("]");
        return b.toString();
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            hashCode = 31 * hashCode + i;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayListInt)) {
            return false;
        }
        ArrayListInt other = (ArrayListInt)o;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == other.array[i]) continue;
            return false;
        }
        return true;
    }
}

