/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.visitors;

import java.util.HashSet;
import java.util.Set;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.ParserWalker;
import norswap.autumn.parsers.AbstractChoice;
import norswap.autumn.parsers.AbstractForwarding;
import norswap.autumn.parsers.AbstractPrimitive;
import norswap.autumn.parsers.AbstractWrapper;
import norswap.autumn.parsers.Around;
import norswap.autumn.parsers.Bounded;
import norswap.autumn.parsers.CharPredicate;
import norswap.autumn.parsers.Choice;
import norswap.autumn.parsers.Collect;
import norswap.autumn.parsers.ContextPredicate;
import norswap.autumn.parsers.Empty;
import norswap.autumn.parsers.Fail;
import norswap.autumn.parsers.GuardedRecursion;
import norswap.autumn.parsers.LazyParser;
import norswap.autumn.parsers.LeftExpression;
import norswap.autumn.parsers.LeftFold;
import norswap.autumn.parsers.LeftRecursive;
import norswap.autumn.parsers.Longest;
import norswap.autumn.parsers.Lookahead;
import norswap.autumn.parsers.Memo;
import norswap.autumn.parsers.Not;
import norswap.autumn.parsers.ObjectPredicate;
import norswap.autumn.parsers.Optional;
import norswap.autumn.parsers.Repeat;
import norswap.autumn.parsers.RightExpression;
import norswap.autumn.parsers.RightFold;
import norswap.autumn.parsers.Sequence;
import norswap.autumn.parsers.StringMatch;
import norswap.autumn.parsers.TokenChoice;
import norswap.autumn.parsers.TokenParser;
import norswap.utils.Vanilla;

public final class VisitorNullable
extends ParserWalker
implements ParserVisitor {
    private static ParserVisitor.HashOverloads overloads = new ParserVisitor.HashOverloads(VisitorNullable.class);
    public Set<Parser> nullables = new HashSet<Parser>();

    @Override
    public ParserVisitor.Overloads overloads() {
        return overloads;
    }

    @Override
    protected void work(Parser parser, ParserWalker.State state) {
        if (state == ParserWalker.State.AFTER) {
            parser.accept(this);
        }
    }

    public boolean nullable(Parser parser) {
        if (this.visited(parser)) {
            return this.nullables.contains(parser);
        }
        this.walk(parser);
        return this.nullables.contains(parser);
    }

    public void add_nullable(Parser parser) {
        this.nullables.add(parser);
    }

    public void add_if_nullable(Parser parser, Parser other) {
        if (this.nullable(other)) {
            this.nullables.add(parser);
        }
    }

    public void add_if(Parser parser, boolean cond) {
        if (cond) {
            this.nullables.add(parser);
        }
    }

    public void add_if_one_nullable(Parser parser, Iterable<Parser> others) {
        for (Parser other : others) {
            if (!this.nullable(other)) continue;
            this.nullables.add(parser);
            return;
        }
    }

    public void add_if_all_nullable(Parser parser, Iterable<Parser> others) {
        for (Parser other : others) {
            if (this.nullable(other)) continue;
            return;
        }
        this.nullables.add(parser);
    }

    @Override
    public void default_action(Parser parser) {
        this.nullables.add(parser);
    }

    @Override
    public void visit(CharPredicate parser) {
    }

    @Override
    public void visit(ObjectPredicate parser) {
    }

    @Override
    public void visit(Fail parser) {
    }

    @Override
    public void visit(ContextPredicate parser) {
        this.nullables.add(parser);
    }

    @Override
    public void visit(Lookahead parser) {
        this.nullables.add(parser);
    }

    @Override
    public void visit(Not parser) {
        this.nullables.add(parser);
    }

    @Override
    public void visit(Optional parser) {
        this.nullables.add(parser);
    }

    @Override
    public void visit(Empty parser) {
        this.nullables.add(parser);
    }

    @Override
    public void visit(Collect parser) {
        this.add_if_nullable(parser, parser.child);
    }

    @Override
    public void visit(LeftRecursive parser) {
        this.add_if_nullable(parser, parser.child);
    }

    @Override
    public void visit(GuardedRecursion parser) {
        this.add_if_nullable(parser, parser.child);
    }

    @Override
    public void visit(Memo parser) {
        this.add_if_nullable(parser, parser.child);
    }

    @Override
    public void visit(AbstractWrapper parser) {
        this.add_if_nullable(parser, parser.child);
    }

    @Override
    public void visit(Bounded parser) {
        this.add_if_nullable(parser, parser.coarse);
    }

    @Override
    public void visit(LazyParser parser) {
        this.add_if_nullable(parser, parser.child());
    }

    @Override
    public void visit(TokenParser parser) {
        this.add_if_nullable(parser, parser.target);
    }

    @Override
    public void visit(AbstractForwarding parser) {
        this.add_if_nullable(parser, parser.forwardee);
    }

    @Override
    public void visit(AbstractChoice parser) {
        this.add_if_one_nullable(parser, parser.children());
    }

    @Override
    public void visit(Choice parser) {
        this.add_if_one_nullable(parser, parser.children());
    }

    @Override
    public void visit(Longest parser) {
        this.add_if_one_nullable(parser, parser.children());
    }

    @Override
    public void visit(TokenChoice parser) {
        this.add_if_one_nullable(parser, parser.children());
    }

    @Override
    public void visit(Sequence parser) {
        this.add_if_all_nullable(parser, parser.children());
    }

    @Override
    public void visit(StringMatch parser) {
        this.add_if(parser, parser.string.equals(""));
    }

    @Override
    public void visit(AbstractPrimitive parser) {
        this.add_if(parser, parser.nullable);
    }

    @Override
    public void visit(Repeat parser) {
        this.add_if(parser, parser.min == 0);
    }

    @Override
    public void visit(Around parser) {
        this.add_if(parser, parser.min == 0 || parser.min == 1 && this.nullable(parser.around) || this.nullable(parser.around) && this.nullable(parser.inside));
    }

    @Override
    public void visit(LeftExpression parser) {
        if (!this.nullable(parser.left)) {
            return;
        }
        if (!parser.operator_required) {
            this.nullables.add(parser);
            return;
        }
        if (this.nullable(parser.right)) {
            this.add_if_one_nullable(parser, Vanilla.list((Object[])parser.infixes));
            return;
        }
        this.add_if_one_nullable(parser, Vanilla.list((Object[])parser.suffixes));
    }

    @Override
    public void visit(RightExpression parser) {
        if (!this.nullable(parser.right)) {
            return;
        }
        if (!parser.operator_required) {
            this.nullables.add(parser);
            return;
        }
        if (this.nullable(parser.left)) {
            this.add_if_one_nullable(parser, Vanilla.list((Object[])parser.infixes));
            return;
        }
        this.add_if_one_nullable(parser, Vanilla.list((Object[])parser.prefixes));
    }

    @Override
    public void visit(LeftFold parser) {
        this.add_if(parser, !parser.operator_required && this.nullable(parser.left) || this.nullable(parser.left) && this.nullable(parser.operator) && this.nullable(parser.right));
    }

    @Override
    public void visit(RightFold parser) {
        this.add_if(parser, !parser.operator_required && this.nullable(parser.right) || this.nullable(parser.left) && this.nullable(parser.operator) && this.nullable(parser.right));
    }
}

