/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.visitors;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.ParserWalker;
import norswap.autumn.parsers.AbstractChoice;
import norswap.autumn.parsers.AbstractForwarding;
import norswap.autumn.parsers.AbstractPrimitive;
import norswap.autumn.parsers.AbstractWrapper;
import norswap.autumn.parsers.Around;
import norswap.autumn.parsers.Bounded;
import norswap.autumn.parsers.CharPredicate;
import norswap.autumn.parsers.Choice;
import norswap.autumn.parsers.Collect;
import norswap.autumn.parsers.ContextPredicate;
import norswap.autumn.parsers.Empty;
import norswap.autumn.parsers.Fail;
import norswap.autumn.parsers.GuardedRecursion;
import norswap.autumn.parsers.LazyParser;
import norswap.autumn.parsers.LeftExpression;
import norswap.autumn.parsers.LeftFold;
import norswap.autumn.parsers.LeftRecursive;
import norswap.autumn.parsers.Longest;
import norswap.autumn.parsers.Lookahead;
import norswap.autumn.parsers.Memo;
import norswap.autumn.parsers.Not;
import norswap.autumn.parsers.ObjectPredicate;
import norswap.autumn.parsers.Optional;
import norswap.autumn.parsers.Repeat;
import norswap.autumn.parsers.RightExpression;
import norswap.autumn.parsers.RightFold;
import norswap.autumn.parsers.Sequence;
import norswap.autumn.parsers.StringMatch;
import norswap.autumn.parsers.TokenChoice;
import norswap.autumn.parsers.TokenParser;
import norswap.autumn.visitors.VisitorNullable;
import norswap.utils.Vanilla;

public final class CopyVisitor
extends ParserWalker
implements ParserVisitor {
    public static boolean emit_warnings = true;
    private static final Parser[] witness = new Parser[0];
    private static ParserVisitor.HashOverloads overloads = new ParserVisitor.HashOverloads(VisitorNullable.class);
    public Map<Parser, Parser> copies = new HashMap<Parser, Parser>();

    @Override
    public ParserVisitor.Overloads overloads() {
        return overloads;
    }

    public Parser get_copy(Parser parser) {
        Parser copy = this.copies.get(parser);
        if (copy != null) {
            return copy;
        }
        this.walk(parser);
        return this.copies.get(parser);
    }

    public void register_copy(Parser original, Parser copy) {
        this.copies.put(original, copy);
    }

    @Override
    protected void work(Parser parser, ParserWalker.State state) {
        switch (state) {
            case RECURSE: {
                this.patch_recursion(parser);
                break;
            }
            case AFTER: {
                parser.accept(this);
            }
        }
    }

    private void patch_recursion(final Parser parser) {
        if (emit_warnings) {
            System.err.println("Warning: detected recursion during grammar copy. This is weird: recursion normally has to be broken with DSL#lazy parsers. We patched it up with a lazy parser for you, but please check what is going on in the original grammar.\n\nYou can disable these warnings by setting CopyVisitor.emit_warnings to false.\n");
            try {
                System.err.println("Recursive parser: " + parser);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Supplier<Parser> supplier = new Supplier<Parser>(){
            private Map<Parser, Parser> copies;
            private Parser original_parser;
            private Parser copy;
            {
                this.copies = CopyVisitor.this.copies;
                this.original_parser = parser;
                this.copy = null;
            }

            @Override
            public Parser get() {
                if (this.copy != null) {
                    return this.copy;
                }
                this.copy = this.copies.get(this.original_parser);
                this.copies = null;
                this.original_parser = null;
                return this.copy;
            }
        };
        this.copies.put(parser, new LazyParser(supplier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void default_action(Parser parser) {
        if (parser instanceof Cloneable) {
            Method m = null;
            try {
                m = parser.getClass().getMethod("clone", new Class[0]);
                m.setAccessible(true);
                this.register_copy(parser, (Parser)m.invoke((Object)parser, new Object[0]));
            }
            catch (ReflectiveOperationException | SecurityException exception) {
            }
            finally {
                if (m != null) {
                    m.setAccessible(false);
                }
            }
        }
        this.register_copy(parser, parser);
    }

    @Override
    public void visit(AbstractChoice parser) {
        this.default_action(parser);
    }

    @Override
    public void visit(AbstractForwarding parser) {
        this.default_action(parser);
    }

    @Override
    public void visit(AbstractPrimitive parser) {
        this.default_action(parser);
    }

    @Override
    public void visit(AbstractWrapper parser) {
        this.default_action(parser);
    }

    @Override
    public void visit(Choice parser) {
        this.register_copy(parser, new Choice((Parser[])Vanilla.map((Collection)parser.children(), (Object[])witness, this::get_copy)));
    }

    @Override
    public void visit(Sequence parser) {
        this.register_copy(parser, new Sequence((Parser[])Vanilla.map((Collection)parser.children(), (Object[])witness, this::get_copy)));
    }

    @Override
    public void visit(Longest parser) {
        this.register_copy(parser, new Longest((Parser[])Vanilla.map((Collection)parser.children(), (Object[])witness, this::get_copy)));
    }

    @Override
    public void visit(CharPredicate parser) {
        this.register_copy(parser, parser);
    }

    @Override
    public void visit(ContextPredicate parser) {
        this.register_copy(parser, parser);
    }

    @Override
    public void visit(Empty parser) {
        this.register_copy(parser, parser);
    }

    @Override
    public void visit(Fail parser) {
        this.register_copy(parser, parser);
    }

    @Override
    public void visit(ObjectPredicate parser) {
        this.register_copy(parser, parser);
    }

    @Override
    public void visit(StringMatch parser) {
        this.register_copy(parser, parser);
    }

    @Override
    public void visit(Lookahead parser) {
        this.register_copy(parser, new Lookahead(this.get_copy(parser.child)));
    }

    @Override
    public void visit(Not parser) {
        this.register_copy(parser, new Not(this.get_copy(parser.child)));
    }

    @Override
    public void visit(Optional parser) {
        this.register_copy(parser, new Optional(this.get_copy(parser.child)));
    }

    @Override
    public void visit(GuardedRecursion parser) {
        this.register_copy(parser, new GuardedRecursion(this.get_copy(parser.child)));
    }

    @Override
    public void visit(Around parser) {
        this.register_copy(parser, new Around(parser.min, parser.exact, parser.trailing, this.get_copy(parser.around), this.get_copy(parser.inside)));
    }

    @Override
    public void visit(Bounded parser) {
        this.register_copy(parser, new Bounded(this.get_copy(parser.coarse), this.get_copy(parser.fine), parser.fallback));
    }

    @Override
    public void visit(Collect parser) {
        this.register_copy(parser, new Collect(parser.name, this.get_copy(parser.child), parser.lookback, parser.action_on_fail, parser.pop, parser.action));
    }

    @Override
    public void visit(LazyParser parser) {
        this.register_copy(parser, new LazyParser(parser::child));
    }

    @Override
    public void visit(LeftExpression parser) {
        Parser[] infixes = (Parser[])Vanilla.map((Object[])parser.infixes, (Object[])witness, this::get_copy);
        Parser[] suffixes = (Parser[])Vanilla.map((Object[])parser.suffixes, (Object[])witness, this::get_copy);
        this.register_copy(parser, new LeftExpression(this.get_copy(parser.left), this.get_copy(parser.right), infixes, parser.infix_steps, suffixes, parser.suffix_steps, parser.operator_required));
    }

    @Override
    public void visit(RightExpression parser) {
        Parser[] infixes = (Parser[])Vanilla.map((Object[])parser.infixes, (Object[])witness, this::get_copy);
        Parser[] prefixes = (Parser[])Vanilla.map((Object[])parser.prefixes, (Object[])witness, this::get_copy);
        this.register_copy(parser, new RightExpression(this.get_copy(parser.left), this.get_copy(parser.right), infixes, parser.infix_steps, prefixes, parser.prefix_steps, parser.operator_required));
    }

    @Override
    public void visit(LeftFold parser) {
        this.register_copy(parser, new LeftFold(this.get_copy(parser.left), this.get_copy(parser.operator), this.get_copy(parser.right), parser.operator_required, parser.step));
    }

    @Override
    public void visit(RightFold parser) {
        this.register_copy(parser, new RightFold(this.get_copy(parser.left), this.get_copy(parser.operator), this.get_copy(parser.right), parser.operator_required, parser.step));
    }

    @Override
    public void visit(LeftRecursive parser) {
        this.register_copy(parser, new LeftRecursive(this.get_copy(parser.child), parser.left_associative));
    }

    @Override
    public void visit(Memo parser) {
        this.register_copy(parser, new Memo(this.get_copy(parser.child), parser.memoizer, parser.context_extractor));
    }

    @Override
    public void visit(Repeat parser) {
        this.register_copy(parser, new Repeat(parser.min, parser.exact, this.get_copy(parser.child)));
    }

    @Override
    public void visit(TokenChoice parser) {
        this.register_copy(parser, new TokenChoice(parser.tokens, (Parser[])Vanilla.map((Object[])parser.targets, (Object[])witness, this::get_copy)));
    }

    @Override
    public void visit(TokenParser parser) {
        this.register_copy(parser, new TokenParser(parser.tokens, this.get_copy(parser.target)));
    }
}

