/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.util;

public final class StringsUtil {
    public static String escape(String string) {
        StringBuilder b = new StringBuilder();
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    b.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    b.append("\\\\");
                    continue block9;
                }
                case '\n': {
                    b.append("\\n");
                    continue block9;
                }
                case '\t': {
                    b.append("\\t");
                    continue block9;
                }
                case '\r': {
                    b.append("\\r");
                    continue block9;
                }
                case '\b': {
                    b.append("\\b");
                    continue block9;
                }
                case '\f': {
                    b.append("\\f");
                    continue block9;
                }
                default: {
                    if (StringsUtil.is_printable(c)) {
                        b.append(c);
                        continue block9;
                    }
                    b.append("\\u").append(String.format("%04x", c));
                }
            }
        }
        return b.toString();
    }

    public static boolean is_printable(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

