/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.util;

import java.util.ArrayList;
import java.util.List;
import norswap.autumn.Parser;
import norswap.autumn.util.StringsUtil;
import norswap.utils.Strings;

public final class ParserStringsUtil {
    public static String pretty_print(Parser parser) {
        return ParserStringsUtil.pretty_print(parser.toString());
    }

    public static String pretty_print_full(Parser parser) {
        return ParserStringsUtil.pretty_print(parser.toStringFull());
    }

    private static String pretty_print(String string) {
        if (!ParserStringsUtil.is_parameterized(string)) {
            return string;
        }
        List<String> components = ParserStringsUtil.components(string);
        if (components.size() == 1) {
            return string;
        }
        StringBuilder b = new StringBuilder();
        b.append(components.get(0));
        if (components.size() == 1 && !ParserStringsUtil.is_parameterized(components.get(1))) {
            b.append('(').append(components.get(1)).append(')');
        } else {
            for (int i = 1; i < components.size(); ++i) {
                b.append("\n").append(Strings.indent((String)ParserStringsUtil.pretty_print(components.get(i)), (String)"    "));
            }
        }
        return b.toString();
    }

    private static boolean is_parameterized(String string) {
        return string.charAt(string.length() - 1) == ')';
    }

    private static List<String> components(String string) {
        int open = string.indexOf(40);
        String head = string.substring(0, open);
        ArrayList<String> components = new ArrayList<String>();
        components.add(head);
        int start = open + 1;
        int end = string.length() - 1;
        while (start < end) {
            String remaining = string.substring(start, end);
            int arg_end = ParserStringsUtil.next_arg_end(remaining);
            start = arg_end + 2;
        }
        return components;
    }

    private static int next_arg_end(String string) {
        int sqbra_count = 0;
        int paren_count = 0;
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '[': {
                    ++sqbra_count;
                    continue block7;
                }
                case ']': {
                    --sqbra_count;
                    continue block7;
                }
                case '(': {
                    if (sqbra_count != 0) continue block7;
                    ++paren_count;
                    continue block7;
                }
                case ')': {
                    if (sqbra_count != 0) continue block7;
                    --paren_count;
                    continue block7;
                }
                case ',': {
                    if (paren_count != 0 || sqbra_count != 0) continue block7;
                    return i;
                }
            }
        }
        return string.length();
    }

    public static String escape_quoted_section(String string) {
        return StringsUtil.escape(string).replace(']', '\u298e');
    }
}

