/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import norswap.utils.Util;

public class ArrayStack<T>
extends ArrayList<T> {
    public ArrayStack() {
    }

    @SafeVarargs
    public ArrayStack(T ... elements) {
        super(elements.length);
        this.add(elements);
    }

    public ArrayStack(int n) {
        super(n);
    }

    public void add(T ... elements) {
        this.addAll(Arrays.asList(elements));
    }

    public void push(T item) {
        this.add(item);
    }

    @SafeVarargs
    public final void push(T ... elements) {
        this.addAll(Arrays.asList(elements));
    }

    public void push(Collection<? extends T> collection) {
        this.addAll(collection);
    }

    private String amt_oob_msg(int n) {
        return "Amount [" + n + "invalid for stack size [" + this.size() + "]";
    }

    private String index_oob_msg(int i) {
        return "Index [" + i + "] invalid for stack size [" + this.size() + "]";
    }

    public List<T> top(int n) {
        if (n < 0 || this.size() < n) {
            throw new IndexOutOfBoundsException(this.amt_oob_msg(n));
        }
        return this.subList(this.size() - n, this.size());
    }

    public List<T> from(int index) {
        if (index < 0 || this.size() < index) {
            throw new IndexOutOfBoundsException(this.index_oob_msg(index));
        }
        return this.subList(index, this.size());
    }

    public void remove_top(int n) {
        if (n < 0 || this.size() < n) {
            throw new IndexOutOfBoundsException(this.amt_oob_msg(n));
        }
        this.top(n).clear();
    }

    public void truncate(int index) {
        if (index < 0 || this.size() < index) {
            throw new IndexOutOfBoundsException(this.index_oob_msg(index));
        }
        this.from(index).clear();
    }

    public T pop() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (T)this.remove(this.size() - 1);
    }

    public T[] pop(int n, IntFunction<T[]> mk_array) {
        if (n < 0 || this.size() < n) {
            throw new IndexOutOfBoundsException(this.amt_oob_msg(n));
        }
        List<T> sub = this.top(n);
        T[] out = sub.toArray(mk_array.apply(n));
        sub.clear();
        return out;
    }

    public T[] pop_from(int index, IntFunction<T[]> mk_array) {
        if (index < 0 || this.size() < index) {
            throw new IndexOutOfBoundsException(this.index_oob_msg(index));
        }
        return this.pop(this.size() - index, mk_array);
    }

    public T poll() {
        return this.isEmpty() ? null : (T)this.remove(this.size() - 1);
    }

    public T peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (T)this.get(this.size() - 1);
    }

    public T[] peek(int n, IntFunction<T[]> mk_array) {
        if (n < 0 || this.size() < n) {
            throw new IndexOutOfBoundsException(this.amt_oob_msg(n));
        }
        return this.top(n).toArray(mk_array.apply(n));
    }

    public T[] peek_from(int index, IntFunction<T[]> mk_array) {
        if (index < 0 || this.size() < index) {
            throw new IndexOutOfBoundsException(this.index_oob_msg(index));
        }
        return this.peek(this.size() - index, mk_array);
    }

    public T snoop() {
        return this.isEmpty() ? null : (T)this.get(this.size() - 1);
    }

    public T peek_back(int n) {
        if (n < 0 || this.size() <= n) {
            throw new IndexOutOfBoundsException(this.index_oob_msg(n));
        }
        return (T)this.get(this.size() - 1 - n);
    }

    public T snoop_back(int n) {
        return n < 0 || this.size() <= n ? null : (T)this.get(this.size() - 1 - n);
    }

    @Override
    public ArrayStack<T> clone() {
        return (ArrayStack)Util.cast((Object)super.clone());
    }
}

