/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import norswap.autumn.Parse;
import norswap.autumn.ParseState;
import norswap.autumn.Parser;
import norswap.autumn.SideEffect;
import norswap.autumn.memo.MemoEntry;
import norswap.autumn.memo.Memoizer;
import norswap.autumn.parsers.TokenChoice;
import norswap.autumn.parsers.TokenParser;
import norswap.utils.NArrays;

public final class Tokens {
    public final ParseState<Memoizer> memo_state;
    Parser[] parsers = new Parser[8];
    private int size = 0;

    public Tokens(Supplier<Memoizer> memo) {
        this.memo_state = new ParseState<Memoizer>(Tokens.class, memo);
    }

    public List<Parser> parsers() {
        return Collections.unmodifiableList(Arrays.asList(NArrays.packed((Object[])this.parsers)));
    }

    private void add(Parser parser) {
        parser.exclude_errors = true;
        if (this.size == this.parsers.length) {
            int quarter = this.parsers.length / 4;
            int complement = quarter % 8 == 0 ? 0 : 8 - quarter % 8;
            this.parsers = Arrays.copyOf(this.parsers, this.parsers.length + quarter + complement);
        }
        this.parsers[this.size++] = parser;
    }

    public TokenParser token_parser(Parser base_parser) {
        if (NArrays.contains((Object[])this.parsers, (Object)base_parser)) {
            return new TokenParser(this, base_parser);
        }
        this.add(base_parser);
        return new TokenParser(this, base_parser);
    }

    public TokenChoice token_choice(Parser ... base_parsers) {
        Parser[] parsers1 = (Parser[])NArrays.map((Object[])base_parsers, (Object[])new Parser[0], it -> {
            if (it instanceof TokenParser) {
                it = ((TokenParser)it).target;
            }
            if (NArrays.contains((Object[])this.parsers, (Object)it)) {
                return it;
            }
            throw new Error("Parser " + it + " is not a recognized token parser or base token parser.");
        });
        return new TokenChoice(this, parsers1);
    }

    boolean parse_token(Parse parse, Parser target) {
        Memoizer memo = this.memo_state.data(parse);
        MemoEntry e = memo.get(null, parse.pos, null);
        if (e == null) {
            e = this.fill_cache(memo, parse);
        }
        if (!e.succeeded() || e.parser != target) {
            return false;
        }
        parse.pos = e.end_position;
        parse.log.apply(e.delta);
        return true;
    }

    boolean parse_token_choice(Parse parse, Parser[] targets) {
        Memoizer memo = this.memo_state.data(parse);
        MemoEntry e = memo.get(null, parse.pos, null);
        if (e == null) {
            e = this.fill_cache(memo, parse);
        }
        if (!e.succeeded()) {
            return false;
        }
        for (Parser target : targets) {
            if (e.parser != target) continue;
            parse.pos = e.end_position;
            parse.log.apply(e.delta);
            return true;
        }
        return false;
    }

    private MemoEntry fill_cache(Memoizer memo, Parse parse) {
        int pos0 = parse.pos;
        int log0 = parse.log.size();
        int longest = -1;
        int max_pos = pos0;
        List<SideEffect> delta = null;
        for (int i = 0; i < this.size; ++i) {
            boolean success = this.parsers[i].parse(parse);
            if (!success) continue;
            if (parse.pos > max_pos) {
                max_pos = parse.pos;
                delta = parse.log.delta(log0);
                longest = i;
            }
            parse.pos = pos0;
            parse.log.rollback(log0);
        }
        boolean success = delta != null;
        MemoEntry entry = new MemoEntry(success, success ? this.parsers[longest] : null, pos0, max_pos, delta, null);
        memo.memoize(entry);
        return entry;
    }
}

