/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Collections;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.util.ParserStringsUtil;

public final class StringMatch
extends Parser {
    public final String string;
    public final Parser whitespace;

    public StringMatch(String string, Parser whitespace) {
        this.string = string;
        this.whitespace = whitespace;
    }

    @Override
    public boolean doparse(Parse parse) {
        if (!parse.match(parse.pos, this.string)) {
            return false;
        }
        parse.pos += this.string.length();
        return this.whitespace == null || this.whitespace.parse(parse);
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterable<Parser> children() {
        return Collections.emptyList();
    }

    @Override
    public String toStringFull() {
        StringBuilder b = new StringBuilder();
        b.append("match(");
        b.append("[").append(ParserStringsUtil.escape_quoted_section(this.string)).append("]");
        if (this.whitespace != null) {
            b.append(", ").append(this.whitespace);
        }
        b.append(")");
        return b.toString();
    }
}

