/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.StackAction;
import norswap.utils.ArrayListInt;

public final class RightFold
extends Parser {
    public final Parser left;
    public final Parser right;
    public final Parser operator;
    public final boolean operator_required;
    public final StackAction step;

    public RightFold(Parser left, Parser operator, Parser right, boolean operator_required, StackAction step) {
        this.left = left;
        this.operator = operator;
        this.right = right;
        this.operator_required = operator_required;
        this.step = step;
    }

    @Override
    protected boolean doparse(Parse parse) {
        boolean no_reparse = false;
        ArrayListInt stack = new ArrayListInt();
        stack.push(parse.pos);
        stack.push(parse.stack.size());
        int log0 = parse.log.size();
        while (this.left.parse(parse)) {
            if (!this.operator.parse(parse)) {
                if (this.right == this.left) {
                    no_reparse = true;
                    break;
                }
                parse.pos = stack.back(1);
                parse.log.rollback(log0);
                break;
            }
            log0 = parse.log.size();
            stack.push(parse.pos);
            stack.push(parse.stack.size());
        }
        stack.pop(2);
        if (this.operator_required && stack.size() == 0) {
            return false;
        }
        if (!no_reparse && !this.right.parse(parse)) {
            return false;
        }
        while (stack.size() > 0) {
            int size0 = stack.pop();
            int pos0 = stack.pop();
            this.step.apply(parse, parse.stack.pop_from(size0), pos0, size0);
        }
        return true;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    public List<Parser> children() {
        return Collections.unmodifiableList(Arrays.asList(this.left, this.operator, this.right));
    }

    @Override
    public String toStringFull() {
        StringBuilder b = new StringBuilder();
        b.append("right_assoc(");
        b.append(this.left).append(", ");
        b.append(this.operator).append(", ");
        b.append(this.right);
        if (this.operator_required) {
            b.append(", operator_required");
        }
        b.append(")");
        return b.toString();
    }
}

