/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.SideEffect;
import norswap.autumn.StackAction;
import norswap.utils.ArrayListInt;
import norswap.utils.ArrayStack;

public final class RightExpression
extends Parser {
    public final Parser left;
    public final Parser right;
    public final Parser[] infixes;
    public final StackAction[] infix_steps;
    public final Parser[] prefixes;
    public final StackAction[] prefix_steps;
    public final boolean operator_required;

    public RightExpression(Parser left, Parser right, Parser[] infixes, StackAction[] infix_steps, Parser[] prefixes, StackAction[] prefix_steps, boolean operator_required) {
        assert (right != null);
        assert (left != null || infixes.length == 0);
        assert (infixes.length == infix_steps.length);
        assert (prefixes.length == prefix_steps.length);
        this.left = left;
        this.right = right;
        this.infixes = infixes;
        this.prefixes = prefixes;
        this.infix_steps = infix_steps;
        this.prefix_steps = prefix_steps;
        this.operator_required = operator_required;
    }

    @Override
    protected boolean doparse(Parse parse) {
        ArrayListInt stack = new ArrayListInt();
        stack.push(parse.pos);
        stack.push(parse.stack.size());
        ArrayStack steps = new ArrayStack();
        int log0 = parse.log.size();
        int right_cached_pos = -1;
        List<SideEffect> right_cached_delta = null;
        block0: while (true) {
            int i;
            if (this.left != null && this.left.parse(parse)) {
                for (i = 0; i < this.infixes.length; ++i) {
                    if (!this.infixes[i].parse(parse)) continue;
                    stack.push(parse.pos);
                    stack.push(parse.stack.size());
                    steps.push((Object)this.infix_steps[i]);
                    log0 = parse.log.size();
                    continue block0;
                }
                if (this.left == this.right) {
                    right_cached_pos = parse.pos;
                    right_cached_delta = parse.log.delta(log0);
                }
                parse.pos = stack.back(1);
                parse.log.rollback(log0);
            }
            for (i = 0; i < this.prefixes.length; ++i) {
                if (!this.prefixes[i].parse(parse)) continue;
                stack.push(parse.pos);
                stack.push(parse.stack.size());
                steps.push((Object)this.prefix_steps[i]);
                log0 = parse.log.size();
                right_cached_pos = -1;
                right_cached_delta = null;
                continue block0;
            }
            break;
        }
        stack.pop(2);
        if (this.operator_required && stack.size() == 0) {
            return false;
        }
        if (right_cached_pos > 0) {
            parse.pos = right_cached_pos;
            parse.log.apply(right_cached_delta);
        } else if (!this.right.parse(parse)) {
            return false;
        }
        while (stack.size() > 0) {
            int size0 = stack.pop();
            int pos0 = stack.pop();
            StackAction step = (StackAction)steps.pop();
            step.apply(parse, parse.stack.pop_from(size0), pos0, size0);
        }
        return true;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    public List<Parser> children() {
        return Collections.unmodifiableList(Stream.of(this.left != null ? Stream.of(this.left) : Stream.empty(), Stream.of(this.right), Arrays.stream(this.infixes), Arrays.stream(this.prefixes)).flatMap(Function.identity()).collect(Collectors.toList()));
    }

    @Override
    public String toStringFull() {
        return "RightExpression(left=" + this.left + ", right=" + this.right + ", ops=" + Arrays.toString(this.infixes) + ", prefixes=" + Arrays.toString(this.prefixes) + ", operator_required=" + this.operator_required + ')';
    }
}

