/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Collections;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;

public final class Repeat
extends Parser {
    public final int min;
    public final boolean exact;
    public final Parser child;

    public Repeat(int min, boolean exact, Parser child) {
        this.min = min;
        this.exact = exact;
        this.child = child;
    }

    @Override
    public boolean doparse(Parse parse) {
        for (int i = 0; i < this.min; ++i) {
            if (this.child.parse(parse)) continue;
            return false;
        }
        if (!this.exact) {
            while (this.child.parse(parse)) {
            }
        }
        return true;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterable<Parser> children() {
        return Collections.singletonList(this.child);
    }

    @Override
    public String toStringFull() {
        StringBuilder b = new StringBuilder();
        b.append("repeat(");
        b.append(this.child).append(", ");
        b.append(this.min);
        if (this.exact) {
            b.append(", exact");
        }
        b.append(")");
        return b.toString();
    }
}

