/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;

public final class ObjectPredicate
extends Parser {
    public String name;
    public final Predicate<Object> predicate;

    public ObjectPredicate(String name, Predicate<Object> predicate) {
        this.name = name;
        this.predicate = predicate;
    }

    @Override
    public boolean doparse(Parse parse) {
        assert (parse.list != null);
        if (this.predicate.test(parse.object_at(parse.pos))) {
            ++parse.pos;
            return true;
        }
        return false;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterable<Parser> children() {
        return Collections.emptyList();
    }

    public static ObjectPredicate instance(Class<?> klass) {
        return new ObjectPredicate("<is? " + klass.getSimpleName() + ">", klass::isInstance);
    }

    public static ObjectPredicate any() {
        return new ObjectPredicate("<any object>", Objects::nonNull);
    }

    @Override
    public String toStringFull() {
        return this.name;
    }
}

