/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Collections;
import java.util.function.Function;
import norswap.autumn.Parse;
import norswap.autumn.ParseState;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.memo.MemoEntry;
import norswap.autumn.memo.Memoizer;

public final class Memo
extends Parser {
    public final Parser child;
    public final ParseState<Memoizer> memoizer;
    public final Function<Parse, Object> context_extractor;

    public Memo(Parser child, ParseState<Memoizer> memoizer, Function<Parse, Object> context_extractor) {
        this.child = child;
        this.memoizer = memoizer;
        this.context_extractor = context_extractor;
    }

    @Override
    protected boolean doparse(Parse parse) {
        Object ctx = this.context_extractor != null ? this.context_extractor.apply(parse) : null;
        Memoizer memo = this.memoizer.data(parse);
        MemoEntry entry = memo.get(this.child, parse.pos, ctx);
        if (entry != null) {
            if (!entry.succeeded()) {
                return false;
            }
            parse.pos = entry.end_position;
            parse.log.apply(entry.delta);
            return true;
        }
        int pos0 = parse.pos;
        int log0 = parse.log.size();
        entry = new MemoEntry(this.child.parse(parse), this.child, pos0, parse.pos, parse.log.delta(log0), ctx);
        memo.memoize(entry);
        return entry.succeeded();
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterable<Parser> children() {
        return Collections.singleton(this.child);
    }

    @Override
    public String toStringFull() {
        return "memo(" + this.child + ")";
    }
}

