/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.SideEffect;
import norswap.utils.Vanilla;

public final class Longest
extends Parser {
    private final Parser[] children;

    public List<Parser> children() {
        return Collections.unmodifiableList(Arrays.asList(this.children));
    }

    public Longest(Parser ... children) {
        this.children = children;
    }

    @Override
    public boolean doparse(Parse parse) {
        int pos0 = parse.pos;
        int log0 = parse.log.size();
        int max_pos = pos0;
        List<SideEffect> delta = null;
        for (Parser child : this.children) {
            boolean success = child.parse(parse);
            if (!success) continue;
            if (parse.pos > max_pos) {
                max_pos = parse.pos;
                delta = parse.log.delta(log0);
            }
            parse.pos = pos0;
            parse.log.rollback(log0);
        }
        if (delta == null) {
            return false;
        }
        parse.pos = max_pos;
        parse.log.apply(delta);
        return true;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toStringFull() {
        StringBuilder b = new StringBuilder();
        b.append("longest(");
        for (Parser child : this.children) {
            b.append(child).append(", ");
        }
        if (this.children.length > 0) {
            Vanilla.pop((StringBuilder)b, (int)2);
        }
        b.append(")");
        return b.toString();
    }
}

