/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Collections;
import java.util.List;
import norswap.autumn.Parse;
import norswap.autumn.ParseState;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.SideEffect;
import norswap.autumn.util.ArrayStack;

public final class LeftRecursive
extends Parser {
    public final Parser child;
    public boolean left_associative;
    public static final ParseState<ArrayStack<LeftRecursiveState>> active_left_recursives = new ParseState<ArrayStack>(LeftRecursive.class, ArrayStack::new);
    private final ParseState<LeftRecursiveState> state_holder = new ParseState<LeftRecursiveState>(this, () -> new LeftRecursiveState());

    public LeftRecursive(Parser child, boolean left_associative) {
        this.child = child;
        this.left_associative = left_associative;
    }

    @Override
    protected boolean doparse(Parse parse) {
        LeftRecursiveState state = this.state_holder.data(parse);
        if (state.recursions == 2) {
            return false;
        }
        int pos0 = parse.pos;
        int log0 = parse.log.size();
        Invocation invoc = (Invocation)state.snoop();
        if (invoc != null && invoc.pos0 == pos0) {
            if (invoc.delta == null) {
                return false;
            }
            parse.pos = invoc.end_pos;
            parse.log.apply(invoc.delta);
            return true;
        }
        if (state.recursions == 1) {
            state.recursions = 2;
            boolean result = this.child.parse(parse);
            state.recursions = 1;
            return result;
        }
        ArrayStack<LeftRecursiveState> left_recursives = null;
        if (state.size() == 0) {
            left_recursives = active_left_recursives.data(parse);
            left_recursives.push(state);
        }
        invoc = new Invocation(pos0, -1, null);
        state.push(invoc);
        if (this.left_associative) {
            state.recursions = 1;
        }
        while (this.child.parse(parse) && parse.pos > invoc.end_pos) {
            invoc.end_pos = parse.pos;
            invoc.delta = parse.log.delta(log0);
            parse.pos = pos0;
            parse.log.rollback(log0);
        }
        if (this.left_associative) {
            state.recursions = 0;
        }
        parse.pos = pos0;
        parse.log.rollback(log0);
        if (left_recursives != null) {
            left_recursives.pop();
        }
        state.pop();
        if (invoc.delta == null) {
            return false;
        }
        parse.pos = invoc.end_pos;
        parse.log.apply(invoc.delta);
        return true;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterable<Parser> children() {
        return Collections.singletonList(this.child);
    }

    @Override
    public void set_rule(String name) {
        this.child.set_rule(name + "(leftrec child)");
        super.set_rule(name);
    }

    @Override
    public String toStringFull() {
        return this.child.rule() != null ? "left_recursive(" + this.child + ")" : (this.rule() != null ? this.rule() : "anonymous left_recursive");
    }

    private final class Invocation {
        public final int pos0;
        public int end_pos;
        public List<SideEffect> delta;

        private Invocation(int pos0, int end_pos, List<SideEffect> delta) {
            this.pos0 = pos0;
            this.end_pos = end_pos;
            this.delta = delta;
        }
    }

    final class LeftRecursiveState
    extends ArrayStack<Invocation> {
        int recursions = 0;

        LeftRecursiveState() {
        }
    }
}

