/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.StackAction;

public final class LeftFold
extends Parser {
    public final Parser left;
    public final Parser right;
    public final Parser operator;
    public final boolean operator_required;
    public final StackAction step;

    public LeftFold(Parser left, Parser operator, Parser right, boolean operator_required, StackAction step) {
        this.left = left;
        this.operator = operator;
        this.right = right;
        this.operator_required = operator_required;
        this.step = step;
    }

    @Override
    public boolean doparse(Parse parse) {
        int pos0 = parse.pos;
        int size0 = parse.stack.size();
        int count = 0;
        if (!this.left.parse(parse)) {
            return false;
        }
        while (true) {
            int pos1 = parse.pos;
            int log1 = parse.log.size();
            if (!this.operator.parse(parse)) break;
            if (!this.right.parse(parse)) {
                parse.pos = pos1;
                parse.log.rollback(log1);
                break;
            }
            ++count;
            if (this.step == null) continue;
            this.step.apply(parse, parse.stack.pop_from(size0), pos0, size0);
        }
        return count > 0 || !this.operator_required;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    public List<Parser> children() {
        return Collections.unmodifiableList(Arrays.asList(this.left, this.operator, this.right));
    }

    @Override
    public String toStringFull() {
        StringBuilder b = new StringBuilder();
        b.append("left_assoc(");
        b.append(this.left).append(", ");
        b.append(this.operator).append(", ");
        b.append(this.right);
        if (this.operator_required) {
            b.append(", operator_required");
        }
        b.append(")");
        return b.toString();
    }
}

