/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.StackAction;

public final class LeftExpression
extends Parser {
    public final Parser left;
    public final Parser right;
    public final Parser[] infixes;
    public final StackAction[] infix_steps;
    public final Parser[] suffixes;
    public final StackAction[] suffix_steps;
    public final boolean operator_required;

    public LeftExpression(Parser left, Parser right, Parser[] infixes, StackAction[] infix_steps, Parser[] suffixes, StackAction[] suffix_steps, boolean operator_required) {
        assert (left != null);
        assert (right != null || infixes.length == 0);
        assert (infixes.length == infix_steps.length);
        assert (suffixes.length == suffix_steps.length);
        this.left = left;
        this.right = right;
        this.infixes = infixes;
        this.suffixes = suffixes;
        this.infix_steps = infix_steps;
        this.suffix_steps = suffix_steps;
        this.operator_required = operator_required;
    }

    @Override
    public boolean doparse(Parse parse) {
        int pos0 = parse.pos;
        int stack0 = parse.stack.size();
        int count = 0;
        if (!this.left.parse(parse)) {
            return false;
        }
        block0: while (true) {
            int i;
            int pos1 = parse.pos;
            int log1 = parse.log.size();
            Object step = null;
            for (i = 0; i < this.infixes.length; ++i) {
                if (!this.infixes[i].parse(parse)) continue;
                if (this.right.parse(parse)) {
                    ++count;
                    this.infix_steps[i].apply(parse, parse.stack.pop_from(stack0), pos0, stack0);
                    continue block0;
                }
                parse.pos = pos1;
                parse.log.rollback(log1);
            }
            for (i = 0; i < this.suffixes.length; ++i) {
                if (!this.suffixes[i].parse(parse)) continue;
                ++count;
                this.suffix_steps[i].apply(parse, parse.stack.pop_from(stack0), pos0, stack0);
                continue block0;
            }
            break;
        }
        return count > 0 || !this.operator_required;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    public List<Parser> children() {
        return Collections.unmodifiableList(Stream.of(Stream.of(this.left), this.right != null ? Stream.of(this.right) : Stream.empty(), Arrays.stream(this.infixes), Arrays.stream(this.suffixes)).flatMap(Function.identity()).collect(Collectors.toList()));
    }

    @Override
    public String toStringFull() {
        return "LeftExpression(left=" + this.left + ", right=" + this.right + ", ops=" + Arrays.toString(this.infixes) + ", suffixes=" + Arrays.toString(this.suffixes) + ", operator_required=" + this.operator_required + ')';
    }
}

