/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Collections;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.StackAction;

public final class Collect
extends Parser {
    public String name;
    public final Parser child;
    public final StackAction action;
    public final int lookback;
    public final boolean pop;
    public final boolean action_on_fail;
    private static final Object MARKER = new Object();

    public Collect(String name, Parser child, int lookback, boolean action_on_fail, boolean pop, StackAction action) {
        if (lookback < 0) {
            throw new IllegalArgumentException("negative lookback");
        }
        this.name = name;
        this.child = child;
        this.lookback = lookback;
        this.pop = pop;
        this.action_on_fail = action_on_fail;
        this.action = action;
    }

    @Override
    public boolean doparse(Parse parse) {
        int pos0 = parse.pos;
        int size0 = parse.stack.size();
        boolean result = this.child.parse(parse);
        if (!result && !this.action_on_fail) {
            return false;
        }
        Object[] items = result ? (this.pop ? parse.stack.pop_from(size0 - this.lookback) : parse.stack.peek_from(size0 - this.lookback, Object[]::new)) : null;
        this.action.apply(parse, items, pos0, size0);
        return true;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterable<Parser> children() {
        return Collections.singleton(this.child);
    }

    @Override
    public String toStringFull() {
        return this.name + "(" + this.child + ")";
    }
}

