/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Collections;
import java.util.function.IntPredicate;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.util.ParserStringsUtil;

public final class CharPredicate
extends Parser {
    public String name;
    public final IntPredicate predicate;

    public CharPredicate(String name, IntPredicate predicate) {
        this.name = name;
        this.predicate = predicate;
    }

    @Override
    public boolean doparse(Parse parse) {
        assert (parse.string != null);
        if (this.predicate.test(parse.char_at(parse.pos))) {
            ++parse.pos;
            return true;
        }
        return false;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterable<Parser> children() {
        return Collections.emptyList();
    }

    @Override
    public String toStringFull() {
        return this.name;
    }

    public static CharPredicate any() {
        return new CharPredicate("<any char>", it -> it != 0);
    }

    public static CharPredicate single(char c) {
        return new CharPredicate("[" + ParserStringsUtil.escape_quoted_section("" + c) + "]", it -> it == c);
    }

    public static CharPredicate range(char start, char end) {
        String str = ParserStringsUtil.escape_quoted_section(start + "-" + end);
        return new CharPredicate("[" + str + "]", it -> start <= it && it <= end);
    }

    public static CharPredicate set(String chars) {
        return new CharPredicate("[" + ParserStringsUtil.escape_quoted_section(chars) + "]", it -> chars.indexOf(it) >= 0);
    }

    public static CharPredicate set(char ... chars) {
        return CharPredicate.set(new String(chars));
    }

    public static CharPredicate alpha() {
        return new CharPredicate("<alpha>", it -> 97 <= it && it <= 122 || 65 <= it && it <= 90);
    }

    public static CharPredicate alphanum() {
        return new CharPredicate("<alpha>", it -> 97 <= it && it <= 122 || 65 <= it && it <= 90 || 48 <= it && it <= 57);
    }

    public static CharPredicate digit() {
        return new CharPredicate("<digit>", it -> 48 <= it && it <= 57);
    }

    public static CharPredicate hex_digit() {
        return new CharPredicate("<hex digit>", it -> 48 <= it && it <= 57 || 97 <= it && it <= 102 || 65 <= it && it <= 70);
    }

    public static CharPredicate octal_digit() {
        return new CharPredicate("<octal digit>", it -> 48 <= it && it <= 55);
    }
}

