/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;

public final class Bounded
extends Parser {
    public final Parser coarse;
    public final Parser fine;
    public final Predicate<Parse> fallback;

    public Bounded(Parser coarse, Parser fine, Predicate<Parse> fallback) {
        this.coarse = coarse;
        this.fine = fine;
        this.fallback = fallback;
    }

    @Override
    protected boolean doparse(Parse parse) {
        int pos0 = parse.pos;
        if (!this.coarse.parse(parse)) {
            return false;
        }
        int log0 = parse.log.size();
        int end0 = parse.end_of_input;
        parse.end_of_input = parse.pos;
        parse.pos = pos0;
        boolean success = this.fine.parse(parse);
        if (success && parse.pos == parse.end_of_input) {
            parse.end_of_input = end0;
            return true;
        }
        parse.pos = parse.end_of_input;
        parse.end_of_input = end0;
        if (success) {
            parse.log.rollback(log0);
        }
        return this.fallback.test(parse);
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    public List<Parser> children() {
        return Collections.unmodifiableList(Arrays.asList(this.coarse, this.fine));
    }

    @Override
    public String toStringFull() {
        return "bounded(" + this.coarse + ", " + this.fine + ")";
    }
}

