/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import norswap.autumn.Parse;
import norswap.autumn.Parser;
import norswap.autumn.ParserVisitor;
import norswap.autumn.parsers.Sequence;

public final class Around
extends Parser {
    public final int min;
    public final boolean exact;
    public final boolean trailing;
    public final Parser around;
    public final Parser inside;
    private final Parser inside_then_around;

    public Around(int min, boolean exact, boolean trailing, Parser around, Parser inside) {
        this.min = min;
        this.exact = exact;
        this.trailing = trailing;
        this.around = around;
        this.inside = inside;
        this.inside_then_around = new Sequence(inside, around);
    }

    @Override
    public boolean doparse(Parse parse) {
        if (!this.around.parse(parse)) {
            if (this.min == 0 && this.trailing) {
                this.inside.parse(parse);
            }
            return this.min == 0;
        }
        for (int i = 0; i < this.min - 1; ++i) {
            if (this.inside_then_around.parse(parse)) continue;
            return false;
        }
        if (!this.exact) {
            while (this.inside_then_around.parse(parse)) {
            }
        }
        if (this.trailing) {
            this.inside.parse(parse);
        }
        return true;
    }

    @Override
    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    public List<Parser> children() {
        return Collections.unmodifiableList(Arrays.asList(this.around, this.inside));
    }

    @Override
    public String toStringFull() {
        StringBuilder b = new StringBuilder();
        b.append("around(");
        b.append(this.around).append(", ");
        b.append(this.inside).append(", ");
        b.append(this.min);
        if (this.exact) {
            b.append(", exact");
        }
        if (this.trailing) {
            b.append(", trailing");
        }
        b.append(")");
        return b.toString();
    }
}

