/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.memo;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import norswap.autumn.LineMap;
import norswap.autumn.Parser;
import norswap.autumn.memo.MemoEntry;
import norswap.autumn.memo.Memoizer;
import norswap.utils.NArrays;
import norswap.utils.Strings;

public final class MemoTable
implements Memoizer {
    private static final double MAX_LOAD = 0.8;
    private long max_displacement = 0L;
    private int occupied = 0;
    private long[] hashes = new long[8];
    private MemoEntry[] entries = new MemoEntry[8];
    public final boolean match_parser;

    public MemoTable(boolean match_parser) {
        this.match_parser = match_parser;
    }

    private void insert(MemoEntry entry) {
        int hash = Memoizer.hash(this.match_parser, entry);
        int i = (hash & Integer.MAX_VALUE) % this.hashes.length;
        long displacement = 0L;
        while (this.hashes[i] != 0L) {
            long d = this.hashes[i] >>> 32;
            if (d <= displacement) {
                int pos2 = (int)this.hashes[i];
                MemoEntry entry2 = this.entries[i];
                this.hashes[i] = (displacement << 32) + (long)hash;
                this.entries[i] = entry;
                if (displacement > this.max_displacement) {
                    this.max_displacement = displacement;
                }
                hash = pos2;
                entry = entry2;
                displacement = d;
            }
            ++displacement;
            if (++i != this.hashes.length) continue;
            i = 0;
        }
        if (displacement > this.max_displacement) {
            this.max_displacement = displacement;
        }
        this.hashes[i] = (displacement << 32) + (long)hash;
        this.entries[i] = entry;
    }

    @Override
    public void memoize(MemoEntry entry) {
        int n;
        ++this.occupied;
        if ((double)n / (double)this.hashes.length > 0.8) {
            int len0 = this.hashes.length;
            MemoEntry[] entries0 = this.entries;
            this.hashes = new long[len0 * 2];
            this.entries = new MemoEntry[len0 * 2];
            for (int j = 0; j < len0; ++j) {
                if (entries0[j] == null) continue;
                this.insert(entries0[j]);
            }
        }
        this.insert(entry);
    }

    @Override
    public MemoEntry get(Parser parser, int pos, Object ctx) {
        int hash = Memoizer.hash(this.match_parser, parser, pos, ctx);
        int i = (hash & Integer.MAX_VALUE) % this.hashes.length;
        int d = 0;
        int h;
        while ((h = (int)this.hashes[i]) != hash || !this.entries[i].matches(this.match_parser, parser, pos, ctx)) {
            if (h == 0 || (long)d > this.max_displacement) {
                return null;
            }
            if (++i == this.hashes.length) {
                i = 0;
            }
            ++d;
        }
        return this.entries[i];
    }

    private String string(String sep, Function<MemoEntry, String> f) {
        Object[] entries = (MemoEntry[])NArrays.packed((Object[])this.entries);
        Arrays.sort(entries, Comparator.comparingInt(x -> x.start_position));
        StringBuilder b = new StringBuilder();
        Strings.separated((StringBuilder)b, (String)sep, (Object[])NArrays.map((Object[])entries, (Object[])new String[0], f));
        return b.toString();
    }

    @Override
    public String toString(LineMap map) {
        return "MemoTable { " + this.string(", ", e -> e.toString(map)) + "}";
    }

    @Override
    public String listing(LineMap map) {
        return this.string("\n", e -> e.listing_string(map, this.match_parser));
    }

    public String toString() {
        return this.toString(null);
    }
}

