/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.memo;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import norswap.autumn.LineMap;
import norswap.autumn.Parser;
import norswap.autumn.SideEffect;

public final class MemoEntry {
    public final Parser parser;
    public final int start_position;
    public final int end_position;
    public final List<SideEffect> delta;
    public final Object ctx;

    public MemoEntry(boolean success, Parser parser, int start_position, int end_position, List<SideEffect> delta, Object ctx) {
        this.parser = parser;
        this.start_position = start_position;
        this.end_position = success ? end_position : -1;
        this.delta = success ? delta : Collections.emptyList();
        this.ctx = ctx;
    }

    public boolean succeeded() {
        return this.end_position >= 0;
    }

    public boolean matches(boolean match_parser, Parser parser, int start_position, Object ctx) {
        return this.start_position == start_position && (!match_parser || this.parser == parser) && Objects.equals(this.ctx, ctx);
    }

    public String listing_string(LineMap map, boolean parser_name) {
        String start = LineMap.string(map, this.start_position);
        if (!this.succeeded()) {
            return "at " + start + ": no match";
        }
        StringBuilder b = new StringBuilder(128);
        b.append("from ").append(start).append(" to ").append(LineMap.string(map, this.end_position));
        if (parser_name) {
            b.append(": ").append(this.parser);
        }
        return b.toString();
    }

    public String toString(LineMap map) {
        StringBuilder b = new StringBuilder(128);
        b.append("MemoEntry {").append("{ parser = ").append(this.parser).append(", ");
        if (this.succeeded()) {
            b.append("range = [").append(LineMap.string(map, this.start_position)).append(" - ").append(LineMap.string(map, this.end_position)).append("]");
        } else {
            b.append("no match");
        }
        b.append(" }");
        return b.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

