/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn.memo;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import norswap.autumn.LineMap;
import norswap.autumn.Parser;
import norswap.autumn.memo.MemoEntry;
import norswap.autumn.memo.Memoizer;
import norswap.utils.NArrays;
import norswap.utils.Strings;

public final class MemoCache
implements Memoizer {
    private final int[] hashes;
    private final MemoEntry[] entries;
    private int next = 0;
    public final int num_slots;
    public final boolean match_parser;

    public MemoCache(int num_slots, boolean match_parser) {
        this.num_slots = num_slots;
        this.match_parser = match_parser;
        this.entries = new MemoEntry[num_slots];
        this.hashes = new int[num_slots];
    }

    @Override
    public void memoize(MemoEntry entry) {
        this.hashes[this.next] = Memoizer.hash(this.match_parser, entry);
        this.entries[this.next] = entry;
        if (++this.next == this.num_slots) {
            this.next = 0;
        }
    }

    @Override
    public MemoEntry get(Parser parser, int pos, Object ctx) {
        int hash = Memoizer.hash(this.match_parser, parser, pos, ctx);
        for (int i = 0; i < this.num_slots; ++i) {
            int j = this.next - 1 - i;
            if (j < 0) {
                j += this.num_slots;
            }
            if (this.hashes[j] == 0) {
                return null;
            }
            if (this.hashes[j] != hash || !this.entries[j].matches(this.match_parser, parser, pos, ctx)) continue;
            return this.entries[j];
        }
        return null;
    }

    private String string(String sep, Function<MemoEntry, String> f) {
        Object[] entries = (MemoEntry[])this.entries.clone();
        Arrays.sort(entries, Comparator.comparingInt(x -> x.start_position));
        StringBuilder b = new StringBuilder();
        Strings.separated((StringBuilder)b, (String)sep, (Object[])NArrays.map((Object[])entries, (Object[])new String[0], f));
        return b.toString();
    }

    @Override
    public String toString(LineMap map) {
        return "MemoCache { " + this.string(", ", e -> e.toString(map)) + "}";
    }

    @Override
    public String listing(LineMap map) {
        return this.string("\n", e -> e.listing_string(map, this.match_parser));
    }

    public String toString() {
        return this.toString(null);
    }
}

