/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import java.util.List;
import norswap.autumn.Autumn;
import norswap.autumn.DSL;
import norswap.autumn.LineMap;
import norswap.autumn.ParseOptions;
import norswap.autumn.ParseResult;
import norswap.autumn.Parser;

public class TestFixture
extends norswap.autumn.util.TestFixture {
    private Parser parser;
    public DSL.rule rule;
    public ParseOptions options;
    public int column_start = 1;
    public int tab_width = 4;
    public boolean run_twice = true;
    public boolean record_call_stack = true;
    public boolean well_formedness_checks = true;
    public boolean only_rules_in_call_stacks = false;

    public void parser(Parser parser) {
        this.rule = null;
        this.parser = parser;
    }

    public TestFixture() {
        this.trace_separator = "\n------";
    }

    private ParseResult run(Object input, boolean record_call_stack) {
        ParseOptions options;
        if (this.rule != null) {
            this.parser = this.rule.get();
        }
        ParseOptions parseOptions = options = this.options != null ? this.options : ParseOptions.record_call_stack(record_call_stack).well_formedness_check(this.well_formedness_checks).get();
        if (input instanceof String) {
            return Autumn.parse(this.parser, (String)input, options);
        }
        if (input instanceof List) {
            return Autumn.parse(this.parser, (List)input, options);
        }
        throw new Error();
    }

    public String compared_status(String msg_head, LineMap map, ParseResult r1, ParseResult r2) {
        StringBuilder b = new StringBuilder(msg_head);
        b.append(" Maybe you made a parser stateful?\n\n");
        b.append("### Initial Parse ###\n\n");
        r1.append_to(b, map, this.only_rules_in_call_stacks);
        b.append("\n\n");
        b.append("### Second Parse ###\n\n");
        r2.append_to(b, map, this.only_rules_in_call_stacks);
        return b.toString();
    }

    private ParseResult prefix(Object input, LineMap map, int peel) {
        ParseResult r1 = this.run(input, this.record_call_stack);
        if (!this.run_twice) {
            this.assert_true(r1.success, peel + 1, () -> r1.toString(map, this.only_rules_in_call_stacks));
            return r1;
        }
        ParseResult r2 = this.run(input, this.record_call_stack || !r1.success);
        this.assert_true(r2.thrown == null || r1.thrown != null, peel + 1, () -> this.compared_status("Second parse throws an exception while the initial parse does not.", map, r1, r2));
        this.assert_true(r1.thrown == null || r2.thrown != null, peel + 1, () -> this.compared_status("Second parse does not throw an exception while the initial parse does.", map, r1, r2));
        if (r1.thrown != null && r2.thrown != null) {
            this.assert_equals(r1.thrown.getClass(), r2.thrown.getClass(), peel + 1, () -> this.compared_status("Second parse does not throw the same type of exception as the initial parse.", map, r1, r2));
        }
        this.assert_equals(r2.success, r1.success, peel + 1, () -> this.compared_status("Second parse does not have the same success as the initial parse.", map, r1, r2));
        if (r1.success) {
            this.assert_equals(r2.match_size, r1.match_size, peel + 1, () -> this.compared_status("Second parse and initial parse do not consume the same amount of input.", map, r1, r2));
        } else {
            this.assert_equals(r2.error_position, r1.error_position, peel + 1, () -> this.compared_status("Second parse and initial parse do not fail at the same position.", map, r1, r2));
        }
        this.assert_true(r1.success, peel + 1, () -> r1.toString(map, this.only_rules_in_call_stacks));
        return r1;
    }

    public ParseResult prefix(Object input, int peel) {
        LineMap map = input instanceof String ? new LineMap((String)input) : null;
        return this.prefix(input, map, peel + 1);
    }

    public ParseResult prefix(Object input) {
        return this.prefix(input, 1);
    }

    public ParseResult prefix_expect(Object input, Object value, int peel) {
        LineMap map = input instanceof String ? new LineMap((String)input) : null;
        ParseResult r = this.prefix(input, map, peel + 1);
        this.assert_true(r.value_stack.size() > 0, peel + 1, () -> "Empty AST stack.");
        this.assert_equals(r.value_stack.peek(), value, peel + 1, () -> "The top of the AST stack did not match the expected value.");
        return r;
    }

    public ParseResult prefix_expect(Object input, Object value) {
        return this.prefix_expect(input, value, 1);
    }

    public ParseResult prefix_of_length(Object input, int length, int peel) {
        LineMap map = input instanceof String ? new LineMap((String)input) : null;
        ParseResult r = this.prefix(input, map, peel + 1);
        this.assert_true(r.match_size == length, peel + 1, () -> r.toString(map, this.only_rules_in_call_stacks));
        return r;
    }

    public ParseResult success(Object input, int peel) {
        LineMap map = input instanceof String ? new LineMap((String)input) : null;
        ParseResult r = this.prefix(input, map, peel + 1);
        this.assert_true(r.full_match, peel + 1, () -> r.toString(map, this.only_rules_in_call_stacks));
        return r;
    }

    public ParseResult success(Object input) {
        return this.success(input, 1);
    }

    public ParseResult success_expect(Object input, Object value, int peel) {
        ParseResult r = this.success(input, peel + 1);
        this.assert_true(r.value_stack.size() > 0, peel + 1, () -> "Empty AST stack.");
        this.assert_equals(r.value_stack.peek(), value, peel + 1, () -> "The top of the AST stack did not match the expected value.");
        return r;
    }

    public ParseResult success_expect(Object input, Object value) {
        return this.success_expect(input, value, 1);
    }

    public ParseResult failure(Object input, int peel) {
        ParseResult r = this.run(input, this.record_call_stack);
        this.assert_true(!r.full_match, peel + 1, () -> "Parse succeeded when it was expected to fail.");
        return r;
    }

    public ParseResult failure(Object input) {
        return this.failure(input, 1);
    }

    public ParseResult failure_at(Object input, int error_position, int peel) {
        ParseResult r = this.failure(input, peel + 1);
        this.assert_equals(r.error_position, error_position, peel + 1, () -> "The furthest parse error didn't occur at the expected location.");
        return r;
    }

    public ParseResult failure_at(Object input, int error) {
        return this.failure_at(input, error, 1);
    }
}

