/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import norswap.autumn.Log;
import norswap.autumn.util.ArrayStack;
import norswap.utils.Slot;

public final class SideEffectingArrayStack
extends ArrayStack<Object> {
    protected final Log log;

    public SideEffectingArrayStack(Log log) {
        this.log = log;
    }

    @Override
    public void push(Object item) {
        this.log.apply(() -> {
            super.push(item);
            return () -> super.pop();
        });
    }

    @Override
    public Object pop() {
        Object out = super.peek();
        this.log.apply(() -> {
            Object x = super.pop();
            return () -> super.push(x);
        });
        return out;
    }

    public Object[] pop(int amount) {
        Slot slot = new Slot();
        this.log.apply(() -> {
            Object[] x;
            slot.x = x = super.pop(amount, Object[]::new);
            return () -> super.push(x);
        });
        return (Object[])slot.x;
    }

    public Object[] pop_from(int index) {
        return this.pop(this.size() - index);
    }
}

