/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import java.util.HashSet;
import java.util.LinkedHashSet;
import norswap.autumn.Parser;

public abstract class ParserWalker {
    private HashSet<Parser> visited = new HashSet();
    private LinkedHashSet<Parser> stack = new LinkedHashSet();

    public final void walk(Parser parser) {
        if (!this.stack.add(parser)) {
            this.work(parser, State.RECURSE);
            return;
        }
        if (!this.visited.add(parser)) {
            this.work(parser, State.VISITED);
            return;
        }
        this.work(parser, State.BEFORE);
        for (Parser child : parser.children()) {
            this.walk(child);
        }
        this.work(parser, State.AFTER);
        this.stack.remove(parser);
    }

    public boolean visited(Parser parser) {
        return this.visited.contains(parser);
    }

    public boolean in_path(Parser parser) {
        return this.stack.contains(parser);
    }

    protected abstract void work(Parser var1, State var2);

    public static enum State {
        BEFORE,
        AFTER,
        RECURSE,
        VISITED;

    }
}

