/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import norswap.autumn.LineMap;
import norswap.autumn.Parser;
import norswap.autumn.ParserCallFrame;
import norswap.autumn.util.ArrayStack;
import norswap.utils.Strings;

public final class ParserCallStack
extends ArrayStack<ParserCallFrame> {
    public void push(Parser parser, int position) {
        this.push(new ParserCallFrame(parser, position));
    }

    public void append_to(StringBuilder b, int indent, LineMap map, boolean only_rules) {
        String tabs = Strings.repeat((char)'\t', (int)indent);
        for (ParserCallFrame frame : this) {
            if (only_rules && frame.parser.rule() == null) continue;
            b.append(tabs).append("at ").append(LineMap.string(map, frame.position)).append(" in ").append(frame.parser).append("\n");
        }
        if (!this.isEmpty()) {
            Strings.pop((StringBuilder)b, (int)1);
        }
    }

    public String toString(LineMap map, boolean only_rules) {
        StringBuilder b = new StringBuilder();
        this.append_to(b, 0, map, only_rules);
        return b.toString();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        this.append_to(b, 0, null, false);
        return b.toString();
    }

    @Override
    public ParserCallStack clone() {
        return (ParserCallStack)super.clone();
    }
}

