/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import norswap.autumn.Parse;
import norswap.autumn.ParserCallStack;
import norswap.autumn.ParserMetrics;
import norswap.autumn.ParserVisitor;

public abstract class Parser {
    private String rule;
    public boolean exclude_errors = false;

    public final String rule() {
        return this.rule;
    }

    public void set_rule(String rule2) {
        if (this.rule != null) {
            throw new Error("rule name already set");
        }
        this.rule = rule2;
    }

    protected abstract boolean doparse(Parse var1);

    public final boolean parse(Parse parse) {
        if (parse.options.trace) {
            return this.tracing_parse(parse);
        }
        int pos0 = parse.pos;
        int log0 = parse.log.size();
        int err0 = parse.error;
        String errmsg0 = parse.error_message;
        ParserCallStack stk0 = parse.error_call_stack;
        if (parse.options.record_call_stack) {
            parse.call_stack.push(this, pos0);
        }
        boolean result = this.doparse(parse);
        if (this.exclude_errors) {
            parse.error = err0;
            parse.error_message = errmsg0;
            parse.error_call_stack = stk0;
        }
        if (result) {
            if (parse.options.record_call_stack) {
                parse.call_stack.pop();
            }
            return true;
        }
        if (!this.exclude_errors && parse.error <= pos0) {
            parse.error = pos0;
            if (parse.error_message == errmsg0) {
                parse.error_message = null;
            }
            if (parse.options.record_call_stack) {
                parse.error_call_stack = parse.call_stack.clone();
            }
        }
        if (parse.options.record_call_stack) {
            parse.call_stack.pop();
        }
        parse.pos = pos0;
        if (parse.log.size() > log0) {
            parse.log.rollback(log0);
        }
        return false;
    }

    private boolean tracing_parse(Parse parse) {
        long time0 = System.nanoTime();
        int trace0 = parse.trace_timings.size();
        ParserMetrics metrics = parse.parse_metrics.metrics.computeIfAbsent(this, k -> new ParserMetrics(this));
        ++metrics.invocations;
        ++metrics.recursive_invocations;
        long time1 = System.nanoTime();
        int pos0 = parse.pos;
        int log0 = parse.log.size();
        int err0 = parse.error;
        ParserCallStack stk0 = parse.error_call_stack;
        if (parse.options.record_call_stack) {
            parse.call_stack.push(this, pos0);
        }
        boolean result = this.doparse(parse);
        if (this.exclude_errors) {
            parse.error = err0;
            parse.error_call_stack = stk0;
        }
        if (result) {
            if (parse.options.record_call_stack) {
                parse.call_stack.pop();
            }
        } else {
            if (!this.exclude_errors && parse.error <= pos0) {
                parse.error = pos0;
                if (parse.options.record_call_stack) {
                    parse.error_call_stack = parse.call_stack.clone();
                }
            }
            if (parse.options.record_call_stack) {
                parse.call_stack.pop();
            }
            parse.pos = pos0;
            parse.log.rollback(log0);
        }
        long total = System.nanoTime() - time1;
        long overheads = 0L;
        long children = 0L;
        int size = parse.trace_timings.size();
        for (int i = trace0; i < size; i += 2) {
            children += parse.trace_timings.pop();
            overheads += parse.trace_timings.pop();
        }
        metrics.self_time += total - children;
        if (--metrics.recursive_invocations == 0) {
            metrics.total_time += total - overheads;
        }
        parse.trace_timings.push(overheads += System.nanoTime() - time0 - total);
        parse.trace_timings.push(System.nanoTime() - time0);
        return result;
    }

    public void accept(ParserVisitor visitor) {
        visitor.visit(this);
    }

    public abstract Iterable<Parser> children();

    public final String toString() {
        return this.rule != null ? this.rule : this.toStringFull();
    }

    public abstract String toStringFull();
}

