/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import java.util.Map;
import norswap.autumn.LineMap;
import norswap.autumn.ParseMetrics;
import norswap.autumn.ParseOptions;
import norswap.autumn.Parser;
import norswap.autumn.ParserCallStack;
import norswap.autumn.util.ArrayStack;
import norswap.utils.Exceptions;
import norswap.utils.Util;

public final class ParseResult {
    public final boolean success;
    public final boolean full_match;
    public final int match_size;
    public final Throwable thrown;
    public final Parser parser;
    public final ParseOptions options;
    public final int error_position;
    public final String error_message;
    public final ArrayStack<?> value_stack;
    public final Map<Object, Object> parse_states;
    public final ParserCallStack error_call_stack;
    public final ParseMetrics parse_metrics;

    public <T> T top_value() {
        return (T)(this.value_stack != null ? Util.cast(this.value_stack.peek()) : null);
    }

    ParseResult(boolean success, boolean full_match, int match_size, Throwable thrown, Parser parser, ParseOptions options, int error_position, String error_message, ArrayStack<?> value_stack, Map<Object, Object> parse_states, ParserCallStack error_call_stack, ParseMetrics parse_metrics) {
        this.success = success;
        this.full_match = full_match;
        this.match_size = match_size;
        this.thrown = thrown;
        this.parser = parser;
        this.options = options;
        this.error_position = error_position;
        this.error_message = error_message;
        this.value_stack = value_stack;
        this.parse_states = parse_states;
        this.error_call_stack = error_call_stack;
        this.parse_metrics = parse_metrics;
    }

    public <T> T parse_state(Object key) {
        return (T)Util.cast((Object)this.parse_states.get(key));
    }

    public void append_to(StringBuilder b, LineMap map, boolean only_rules) {
        if (this.full_match) {
            b.append("Parse succeeded, consuming the whole input.\n");
            return;
        }
        if (this.thrown != null) {
            b.append("Exception thrown at position ");
            b.append(LineMap.string(map, this.error_position));
            if (this.options.record_call_stack) {
                b.append("\n");
                b.append(this.thrown.getClass());
                b.append(": ");
                b.append(this.thrown.getMessage());
                b.append("\n\nParser trace:\n");
                this.error_call_stack.append_to(b, 1, map, false);
            }
            b.append("\n\nThrown: ");
            b.append(Exceptions.string_stack_trace((Throwable)this.thrown));
            return;
        }
        if (this.success) {
            b.append("Parse succeeded, consuming up to ").append(LineMap.string(map, this.match_size)).append(".\n");
        } else {
            b.append("Parse failed.\n");
        }
        b.append("Furthest parse error at ").append(LineMap.string(map, this.error_position)).append(".\n");
        if (this.options.record_call_stack) {
            this.error_call_stack.append_to(b, 1, map, only_rules);
            b.append("\n");
        }
    }

    public String toString(LineMap map, boolean only_rules) {
        StringBuilder b = new StringBuilder();
        this.append_to(b, map, only_rules);
        return b.toString();
    }

    public String toString() {
        return this.toString(null, false);
    }
}

