/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import java.util.HashMap;
import java.util.function.Supplier;
import norswap.autumn.ParseMetrics;
import norswap.utils.Util;

public final class ParseOptions {
    public final boolean trace;
    public final boolean record_call_stack;
    public final boolean well_formedness_check;
    public final Supplier<ParseMetrics> metrics;
    private final HashMap<Object, Object> custom_options;

    public <T> T get(Object key) {
        return (T)Util.cast((Object)this.custom_options.get(key));
    }

    private ParseOptions(boolean trace, boolean record_call_stack, boolean well_formedness_check, Supplier<ParseMetrics> metrics, HashMap<Object, Object> custom_options) {
        this.trace = trace;
        this.record_call_stack = record_call_stack;
        this.well_formedness_check = well_formedness_check;
        this.metrics = metrics;
        this.custom_options = custom_options;
    }

    public static ParseOptionsBuilder custom(Object key, Object value) {
        return new ParseOptionsBuilder().custom(key, value);
    }

    public static ParseOptionsBuilder trace(boolean enabled) {
        return new ParseOptionsBuilder().trace(enabled);
    }

    public static ParseOptionsBuilder record_call_stack(boolean enabled) {
        return new ParseOptionsBuilder().record_call_stack(enabled);
    }

    public static ParseOptionsBuilder well_formedness_check(boolean enabled) {
        return new ParseOptionsBuilder().well_formedness_check(enabled);
    }

    public static ParseOptionsBuilder metrics(Supplier<ParseMetrics> metrics) {
        return new ParseOptionsBuilder().metrics(metrics);
    }

    public static ParseOptionsBuilder builder() {
        return new ParseOptionsBuilder();
    }

    public static ParseOptions get() {
        return new ParseOptionsBuilder().get();
    }

    public static final class ParseOptionsBuilder {
        private boolean trace = false;
        private boolean record_call_stack = false;
        private boolean well_formedness_check = true;
        private Supplier<ParseMetrics> metrics = null;
        private HashMap<Object, Object> custom_options = new HashMap();

        private ParseOptionsBuilder() {
        }

        public ParseOptionsBuilder custom(Object key, Object value) {
            this.custom_options.put(key, value);
            return this;
        }

        public ParseOptionsBuilder trace(boolean enabled) {
            this.trace = enabled;
            if (!enabled) {
                this.metrics = null;
            } else if (this.metrics == null) {
                this.metrics = ParseMetrics::new;
            }
            return this;
        }

        public ParseOptionsBuilder record_call_stack(boolean enabled) {
            this.record_call_stack = enabled;
            return this;
        }

        public ParseOptionsBuilder well_formedness_check(boolean enabled) {
            this.well_formedness_check = enabled;
            return this;
        }

        public ParseOptionsBuilder metrics(Supplier<ParseMetrics> metrics) {
            this.trace = metrics != null;
            this.metrics = metrics;
            return this;
        }

        public ParseOptions get() {
            return new ParseOptions(this.trace, this.record_call_stack, this.well_formedness_check, this.metrics, this.custom_options);
        }
    }
}

