/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import norswap.autumn.Log;
import norswap.autumn.MalformedGrammarError;
import norswap.autumn.ParseMetrics;
import norswap.autumn.ParseOptions;
import norswap.autumn.ParseResult;
import norswap.autumn.ParseState;
import norswap.autumn.Parser;
import norswap.autumn.ParserCallStack;
import norswap.autumn.SideEffectingArrayStack;
import norswap.autumn.visitors.WellFormednessChecker;
import norswap.utils.ArrayListLong;

public final class Parse {
    public int pos = 0;
    public int error = -1;
    String error_message;
    public int end_of_input;
    public final String string;
    public final List<?> list;
    public final ParseOptions options;
    public final Log log = new Log();
    public final SideEffectingArrayStack stack = new SideEffectingArrayStack(this.log);
    public final Map<Object, Object> state_data = new HashMap<Object, Object>();
    ArrayList<ParseState<?>> parse_states = new ArrayList();
    public ParserCallStack call_stack;
    public ParserCallStack error_call_stack;
    final ArrayListLong trace_timings;
    final ParseMetrics parse_metrics;

    private Parse(String string, List<?> list, ParseOptions options) {
        assert (string != null && list == null || string == null && list != null);
        options = options != null ? options : ParseOptions.get();
        this.string = string;
        this.list = list;
        this.end_of_input = string != null ? string.length() : list.size();
        this.options = options;
        this.call_stack = options.record_call_stack ? new ParserCallStack() : null;
        this.trace_timings = options.trace ? new ArrayListLong(256) : null;
        this.parse_metrics = options.trace ? options.metrics.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParseResult run(Parser parser, String string, List<?> list, ParseOptions options) {
        String error_message;
        int error_position;
        int match_size;
        WellFormednessChecker checker;
        if (options.well_formedness_check && !(checker = new WellFormednessChecker()).well_formed(parser)) {
            StringBuilder b = new StringBuilder();
            for (Parser p : checker.left_recursives) {
                b.append("\n- Left-recursive parser cycle detected, passing through parser: ").append(p);
            }
            for (Parser p : checker.nullable_repetitions) {
                b.append("\n- Nullable repetition detected: ").append(p);
            }
            throw new MalformedGrammarError(b.toString(), checker);
        }
        Parse parse = new Parse(string, list, options);
        Throwable thrown = null;
        boolean success = false;
        try {
            success = parser.parse(parse);
        }
        catch (StackOverflowError e) {
            throw e;
        }
        catch (Throwable t) {
            thrown = t;
            return thrown;
        }
        finally {
            for (ParseState<?> state : parse.parse_states) {
                state.discard_cache(parse);
            }
        }
        boolean full_match = success && parse.pos == parse.input_length();
        int n = match_size = success ? parse.pos : -1;
        int n2 = full_match ? -1 : (error_position = thrown != null ? parse.pos : parse.error);
        String string2 = full_match ? null : (error_message = thrown != null ? thrown.getMessage() : parse.error_message);
        ParserCallStack error_call_stack = thrown != null ? parse.call_stack : (full_match ? null : parse.error_call_stack);
        return new ParseResult(success, full_match, match_size, thrown, parser, options, error_position, error_message, parse.stack, parse.state_data, error_call_stack, parse.parse_metrics);
    }

    public String error_message() {
        return this.error_message;
    }

    public void set_error_message(String string) {
        this.error_message = string == this.error_message ? new String(string) : string;
    }

    public int input_length() {
        return this.string != null ? this.string.length() : this.list.size();
    }

    public char char_at(int index) {
        assert (this.string != null);
        return index != this.end_of_input ? this.string.charAt(index) : (char)'\u0000';
    }

    public Object object_at(int index) {
        assert (this.list != null);
        return index != this.list.size() ? this.list.get(index) : null;
    }

    public boolean match(int index, String candidate) {
        assert (this.string != null);
        if (this.string.length() < index + candidate.length()) {
            return false;
        }
        for (int i = 0; i < candidate.length(); ++i) {
            if (this.string.charAt(index + i) == candidate.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

