/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import java.util.ArrayList;
import java.util.Arrays;

public final class LineMap {
    public final String string;
    public final int[] line_positions;
    public final int tab_size;
    public final int column_start;
    private static final int line_start = 1;

    public LineMap(String string, int tab_size, int column_start) {
        this.string = string;
        this.tab_size = tab_size;
        this.column_start = column_start;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(0);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != '\n') continue;
            positions.add(i2 + 1);
        }
        this.line_positions = positions.stream().mapToInt(i -> i).toArray();
    }

    public LineMap(String string) {
        this(string, 4, 1);
    }

    public static String string(LineMap map, int offset) {
        try {
            return map == null ? "" + offset : "" + map.position_from(offset);
        }
        catch (IndexOutOfBoundsException e) {
            return "" + offset + " (out of bounds)";
        }
    }

    private int line_offset(int line) {
        return this.line_positions[line - 1];
    }

    public int line_from(int offset) {
        if (offset < 0 || this.string.length() < offset) {
            throw new IndexOutOfBoundsException("offset " + offset);
        }
        int index = Arrays.binarySearch(this.line_positions, offset);
        return index >= 0 ? index + 1 : -index - 2 + 1;
    }

    private int column_from(int line, int offset) {
        int line_offset = this.line_offset(line);
        int col = 0;
        for (int i = line_offset; i < offset; ++i) {
            col += this.string.charAt(i) == '\t' ? this.tab_size - col % this.tab_size : 1;
        }
        return col + this.column_start;
    }

    public int column_from(int offset) {
        int line = this.line_from(offset);
        return this.column_from(line, offset);
    }

    public Position position_from(int offset) {
        int line = this.line_from(offset);
        int column = this.column_from(line, offset);
        return new Position(line, column);
    }

    private RuntimeException no_column(int line, int column) {
        return new IndexOutOfBoundsException("no column " + column + " in line " + line);
    }

    public int offset_from(Position position) {
        int line = position.line;
        int column = position.column;
        if (line < 1 || this.line_positions.length + 1 <= line) {
            throw new IndexOutOfBoundsException("line " + line);
        }
        int line_offset = this.line_offset(line);
        if (column < this.column_start) {
            throw this.no_column(line, column);
        }
        int column_offset = 0;
        int column_index = 0;
        while (column_index + this.column_start < column) {
            char c = this.string.charAt(line_offset + column_offset);
            if (c == '\n') {
                throw this.no_column(line, column);
            }
            column_index += c == '\t' ? this.tab_size - column_index % this.tab_size : 1;
            ++column_offset;
        }
        if (column_index + this.column_start != column) {
            throw new IllegalArgumentException("column " + column + " happens inside a tab");
        }
        return line_offset + column_offset;
    }

    public static class Position {
        public int line;
        public int column;

        public Position(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int hashCode() {
            return this.line * 31 + this.column;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Position)) {
                return false;
            }
            Position p = (Position)other;
            return this.line == p.line && this.column == p.column;
        }

        public String toString() {
            return this.line + ":" + this.column;
        }
    }
}

