/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import norswap.autumn.Parse;
import norswap.autumn.ParseState;
import norswap.autumn.Parser;
import norswap.autumn.StackAction;
import norswap.autumn.memo.MemoCache;
import norswap.autumn.memo.MemoTable;
import norswap.autumn.memo.Memoizer;
import norswap.autumn.parsers.Around;
import norswap.autumn.parsers.CharPredicate;
import norswap.autumn.parsers.Choice;
import norswap.autumn.parsers.Collect;
import norswap.autumn.parsers.ContextPredicate;
import norswap.autumn.parsers.Empty;
import norswap.autumn.parsers.Fail;
import norswap.autumn.parsers.GuardedRecursion;
import norswap.autumn.parsers.LazyParser;
import norswap.autumn.parsers.LeftExpression;
import norswap.autumn.parsers.LeftFold;
import norswap.autumn.parsers.LeftRecursive;
import norswap.autumn.parsers.Longest;
import norswap.autumn.parsers.Lookahead;
import norswap.autumn.parsers.Memo;
import norswap.autumn.parsers.Not;
import norswap.autumn.parsers.ObjectPredicate;
import norswap.autumn.parsers.Optional;
import norswap.autumn.parsers.Repeat;
import norswap.autumn.parsers.RightExpression;
import norswap.autumn.parsers.RightFold;
import norswap.autumn.parsers.Sequence;
import norswap.autumn.parsers.StringMatch;
import norswap.autumn.parsers.Tokens;
import norswap.utils.NArrays;
import norswap.utils.Slot;
import norswap.utils.Util;

public class DSL {
    public final Tokens tokens;
    public rule ws = null;
    public boolean exclude_ws_errors = true;
    public rule empty = new rule(new Empty());
    public rule fail = new rule(new Fail());
    public rule any = new rule(CharPredicate.any());
    public rule alpha = new rule(CharPredicate.alpha());
    public rule alphanum = new rule(CharPredicate.alphanum());
    public rule digit = new rule(CharPredicate.digit());
    public rule hex_digit = new rule(CharPredicate.hex_digit());
    public rule octal_digit = new rule(CharPredicate.octal_digit());
    public rule usual_whitespace = this.set(" \t\n\r").at_least(0);

    public DSL() {
        this.tokens = new Tokens(() -> new MemoCache(8, false));
    }

    public DSL(Supplier<Memoizer> token_memo) {
        this.tokens = new Tokens(token_memo);
    }

    private Parser ws() {
        Parser p = this.ws.get();
        if (!p.exclude_errors && this.exclude_ws_errors) {
            p.exclude_errors = true;
        }
        return p;
    }

    private Parser compile(Object item) {
        if (item instanceof rule) {
            return ((rule)item).get();
        }
        if (item instanceof Parser) {
            return (Parser)item;
        }
        if (item instanceof String) {
            return new StringMatch((String)item, null);
        }
        throw new Error("unknown item type " + item.getClass());
    }

    public rule rule(Parser parser) {
        return new rule(parser);
    }

    public <T> T $(Object object) {
        return (T)object;
    }

    public <T> T $(Object[] array, int index) {
        return (T)array[index];
    }

    public <T> List<T> list() {
        return Collections.emptyList();
    }

    public <T> List<T> list(Object ... array) {
        return Arrays.asList(array);
    }

    public <T> List<T> list(int start, Object[] array) {
        return Arrays.asList(Arrays.copyOfRange(array, start, array.length));
    }

    public <T> List<T> list(int start, int end, Object[] array) {
        return Arrays.asList(Arrays.copyOfRange(array, start, end));
    }

    public void make_rule_names() {
        this.make_rule_names(this.getClass());
    }

    public void make_rule_names(Class<?> klass) {
        this.make_rule_names(DSL.class.getFields());
        this.make_rule_names(klass.getDeclaredFields());
    }

    private void make_rule_names(Field[] fields) {
        try {
            for (Field f : fields) {
                Parser p;
                if (!Modifier.isPublic(f.getModifiers()) && !f.isAccessible()) {
                    f.setAccessible(true);
                }
                if (f.getType().equals(rule.class)) {
                    Parser p2;
                    rule w = (rule)f.get(this);
                    if (w == null || (p2 = w.get()).rule() != null) continue;
                    p2.set_rule(f.getName());
                    continue;
                }
                if (!f.getType().equals(Parser.class) || (p = (Parser)f.get(this)) == null || p.rule() != null) continue;
                p.set_rule(f.getName());
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException("The security policy does not allow Autumn to access private or protected fields in the grammar. Either make all the fields containing grammar rules public, or amend the security policy by granting: permission java.lang.reflect.ReflectPermission \"suppressAccessChecks\";", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public rule seq(Object ... parsers) {
        return new rule(new Sequence((Parser[])NArrays.map((Object[])parsers, (Object[])new Parser[0], this::compile)));
    }

    public rule choice(Object ... parsers) {
        return new rule(new Choice((Parser[])NArrays.map((Object[])parsers, (Object[])new Parser[0], this::compile)));
    }

    public rule longest(Object ... parsers) {
        return new rule(new Longest((Parser[])NArrays.map((Object[])parsers, (Object[])new Parser[0], this::compile)));
    }

    public rule str(String string) {
        return new rule(new StringMatch(string, null));
    }

    public rule word(String string) {
        return new rule(new StringMatch(string, this.ws()));
    }

    public rule character(char character) {
        return new rule(CharPredicate.single(character));
    }

    public rule range(char start, char end) {
        return new rule(CharPredicate.range(start, end));
    }

    public rule set(String string) {
        return new rule(CharPredicate.set(string));
    }

    public rule set(char ... chars) {
        return new rule(CharPredicate.set(chars));
    }

    public rule cpred(IntPredicate predicate) {
        return new rule(new CharPredicate("cpred", predicate));
    }

    public rule opred(Predicate<Object> predicate) {
        return new rule(new ObjectPredicate("opred", predicate));
    }

    public rule context(Predicate<Parse> predicate) {
        return new rule(new ContextPredicate("context", predicate));
    }

    public rule token_choice(Object ... parsers) {
        Parser[] compiled_parsers = new Parser[parsers.length];
        for (int i = 0; i < parsers.length; ++i) {
            if (parsers[i] instanceof String) {
                throw new Error("Token choice requires exact parser reference and does not work with automatic string conversion. String:" + parsers[i]);
            }
            compiled_parsers[i] = this.compile(parsers[i]);
        }
        return new rule(this.tokens.token_choice(compiled_parsers));
    }

    public LeftExpressionBuilder left_expression() {
        return new LeftExpressionBuilder();
    }

    public RightExpressionBuilder right_expression() {
        return new RightExpressionBuilder();
    }

    public rule lazy_parser(Supplier<Parser> supplier) {
        return new rule(new LazyParser(supplier));
    }

    public rule lazy(Supplier<rule> supplier) {
        return new rule(new LazyParser(() -> ((rule)supplier.get()).parser));
    }

    private rule recursive_parser(Function<rule, Parser> f) {
        Slot slot = new Slot();
        slot.x = f.apply(new rule(new LazyParser(() -> (Parser)slot.x)));
        return new rule((Parser)slot.x);
    }

    public rule recursive(Function<rule, rule> f) {
        return this.recursive_parser(r -> ((rule)f.apply((rule)r)).get());
    }

    public rule left_recursive(Function<rule, rule> f) {
        return this.recursive_parser(r -> new LeftRecursive(((rule)f.apply((rule)r)).get(), false));
    }

    public rule left_recursive_left_assoc(Function<rule, rule> f) {
        return this.recursive_parser(r -> new LeftRecursive(((rule)f.apply((rule)r)).get(), true));
    }

    public rule left_fold(Object left, Object operator, Object right, StackAction.Push step) {
        return new rule(new LeftFold(this.compile(left), this.compile(operator), this.compile(right), false, step));
    }

    public rule left_fold(Object left, Object operator, Object right) {
        return new rule(new LeftFold(this.compile(left), this.compile(operator), this.compile(right), false, null));
    }

    public rule left_fold(Object operand, Object operator, StackAction.Push step) {
        Parser coperand = this.compile(operand);
        return new rule(new LeftFold(coperand, this.compile(operator), coperand, false, step));
    }

    public rule left_fold_full(Object left, Object operator, Object right, StackAction.Push step) {
        return new rule(new LeftFold(this.compile(left), this.compile(operator), this.compile(right), true, step));
    }

    public rule left_fold_full(Object operand, Object operator, StackAction.Push step) {
        Parser coperand = this.compile(operand);
        return new rule(new LeftFold(coperand, this.compile(operator), coperand, true, step));
    }

    public rule right_fold(Object left, Object operator, Object right, StackAction.Push step) {
        return new rule(new RightFold(this.compile(left), this.compile(operator), this.compile(right), false, step));
    }

    public rule right_fold(Object operand, Object operator, StackAction.Push step) {
        Parser coperand = this.compile(operand);
        return new rule(new RightFold(coperand, this.compile(operator), coperand, false, step));
    }

    public rule right_fold_full(Object left, Object operator, Object right, StackAction.Push step) {
        return new rule(new RightFold(this.compile(left), this.compile(operator), this.compile(right), true, step));
    }

    public rule right_fold_full(Object operand, Object operator, StackAction.Push step) {
        Parser coperand = this.compile(operand);
        return new rule(new RightFold(coperand, this.compile(operator), coperand, true, step));
    }

    public rule postfix(Object operand, Object operator, StackAction.Push step) {
        return new rule(new LeftFold(this.compile(operand), this.compile(operator), this.empty.get(), false, step));
    }

    public rule postfix_full(Object operand, Object operator, StackAction.Push step) {
        return new rule(new LeftFold(this.compile(operand), this.compile(operator), this.empty.get(), true, step));
    }

    public rule prefix(Object operator, Object operand, StackAction.Push step) {
        return new rule(new RightFold(this.empty.get(), this.compile(operand), this.compile(operator), false, step));
    }

    public rule prefix_full(Object operator, Object operand, StackAction.Push step) {
        return new rule(new RightFold(this.empty.get(), this.compile(operand), this.compile(operator), true, step));
    }

    public StackAction.PushWithParse with_parse(StackAction.PushWithParse action) {
        return action;
    }

    public StackAction.PushWithString with_string(StackAction.PushWithString action) {
        return action;
    }

    public StackAction.PushWithList with_list(StackAction.PushWithList action) {
        return action;
    }

    public final class RightExpressionBuilder
    extends ExpressionBuilder<RightExpressionBuilder> {
        RightExpressionBuilder() {
            super(false);
        }

        RightExpressionBuilder(boolean left_associative, Parser left, Parser right, Parser[] ops, StackAction[] op_steps, Parser[] affixes, StackAction[] affix_steps, boolean require_other_side) {
            super(left_associative, require_other_side, left, right, ops, op_steps, affixes, affix_steps);
        }

        @Override
        RightExpressionBuilder copy(boolean require_other_side, Parser right, Parser left, Parser[] infixes, StackAction[] infix_steps, Parser[] affixes, StackAction[] affix_steps) {
            return new RightExpressionBuilder(this.left_associative, left, right, infixes, infix_steps, affixes, affix_steps, require_other_side);
        }

        public RightExpressionBuilder _maybe_slow_left(rule left) {
            return (RightExpressionBuilder)this._left(left);
        }

        public RightExpressionBuilder _maybe_slow_right(rule right) {
            return (RightExpressionBuilder)this._right(right);
        }

        public RightExpressionBuilder prefix(rule op, StackAction.Push step) {
            return (RightExpressionBuilder)this.affix(op, step);
        }

        @Override
        public RightExpressionBuilder require_operator() {
            return (RightExpressionBuilder)super.require_operator();
        }

        @Override
        public rule get() {
            if (this.right == null) {
                throw new IllegalStateException("No right operand specified for a right-associative expression.");
            }
            if (this.left == null && this.infixes.length > 0) {
                throw new IllegalStateException("No left operand specified for a right-associative expression, but operators have been defined.");
            }
            if (this.require_operator && this.infixes.length == 0 && this.affixes.length == 0) {
                throw new IllegalStateException("Left-side required but no prefix or operator has been defined.");
            }
            if (this.infixes.length == 1 && this.affixes.length == 0) {
                return new rule(new RightFold(this.left, this.infixes[0], this.right, this.require_operator, this.infix_steps[0]));
            }
            if (this.infixes.length == 0 && this.affixes.length == 1) {
                return new rule(new RightFold(DSL.this.empty.get(), this.affixes[0], this.right, this.require_operator, this.affix_steps[0]));
            }
            return DSL.this.rule(new RightExpression(this.left, this.right, this.infixes, this.infix_steps, this.affixes, this.affix_steps, this.require_operator));
        }
    }

    public final class LeftExpressionBuilder
    extends ExpressionBuilder<LeftExpressionBuilder> {
        LeftExpressionBuilder() {
            super(true);
        }

        LeftExpressionBuilder(boolean left_associative, Parser left, Parser right, Parser[] ops, StackAction[] op_steps, Parser[] affixes, StackAction[] affix_steps, boolean require_other_side) {
            super(left_associative, require_other_side, left, right, ops, op_steps, affixes, affix_steps);
        }

        @Override
        LeftExpressionBuilder copy(boolean require_other_side, Parser right, Parser left, Parser[] infixes, StackAction[] infix_steps, Parser[] affixes, StackAction[] affix_steps) {
            return new LeftExpressionBuilder(this.left_associative, left, right, infixes, infix_steps, affixes, affix_steps, require_other_side);
        }

        public LeftExpressionBuilder left(rule left) {
            return (LeftExpressionBuilder)this._left(left);
        }

        public LeftExpressionBuilder right(rule right) {
            return (LeftExpressionBuilder)this._right(right);
        }

        public LeftExpressionBuilder suffix(rule op, StackAction.Push step) {
            return (LeftExpressionBuilder)this.affix(op, step);
        }

        @Override
        public LeftExpressionBuilder require_operator() {
            return (LeftExpressionBuilder)super.require_operator();
        }

        @Override
        public rule get() {
            if (this.left == null) {
                throw new IllegalStateException("No left operand specified for a left-associative expression.");
            }
            if (this.right == null && this.infixes.length > 0) {
                throw new IllegalStateException("No right operand specified for a left-associative expression, but operators have been defined.");
            }
            if (this.require_operator && this.infixes.length == 0 && this.affixes.length == 0) {
                throw new IllegalStateException("Right-side required but no prefix or operator has been defined.");
            }
            if (this.infixes.length == 1 && this.affixes.length == 0) {
                return new rule(new LeftFold(this.left, this.infixes[0], this.right, this.require_operator, this.infix_steps[0]));
            }
            if (this.infixes.length == 0 && this.affixes.length == 1) {
                return new rule(new LeftFold(this.left, this.affixes[0], DSL.this.empty.get(), this.require_operator, this.affix_steps[0]));
            }
            return DSL.this.rule(new LeftExpression(this.left, this.right, this.infixes, this.infix_steps, this.affixes, this.affix_steps, this.require_operator));
        }
    }

    public abstract class ExpressionBuilder<Self extends ExpressionBuilder<Self>> {
        final boolean left_associative;
        final boolean require_operator;
        final Parser left;
        final Parser right;
        final Parser[] infixes;
        final StackAction[] infix_steps;
        final Parser[] affixes;
        final StackAction[] affix_steps;

        ExpressionBuilder(boolean left_associative, boolean require_operator, Parser left, Parser right, Parser[] infixes, StackAction[] infix_steps, Parser[] affixes, StackAction[] affix_steps) {
            this.left_associative = left_associative;
            this.left = left;
            this.right = right;
            this.infixes = infixes;
            this.infix_steps = infix_steps;
            this.affixes = affixes;
            this.affix_steps = affix_steps;
            this.require_operator = require_operator;
        }

        ExpressionBuilder(boolean left_associative) {
            this(left_associative, false, null, null, new Parser[0], new StackAction[0], new Parser[0], new StackAction[0]);
        }

        abstract Self copy(boolean var1, Parser var2, Parser var3, Parser[] var4, StackAction[] var5, Parser[] var6, StackAction[] var7);

        public abstract rule get();

        public Self operand(rule op) {
            if (this.left != null) {
                throw new IllegalStateException("Trying to redefine the left operand.");
            }
            if (this.right != null) {
                throw new IllegalStateException("Trying to redefine the right operand.");
            }
            return this.copy(this.require_operator, op.get(), op.get(), this.infixes, this.infix_steps, this.affixes, this.affix_steps);
        }

        public Self infix(rule op, StackAction.Push step) {
            Parser[] ops = (Parser[])NArrays.append((Object[])this.infixes, (Object[])new Parser[]{op.get()});
            StackAction[] op_steps = (StackAction[])NArrays.append((Object[])this.infix_steps, (Object[])new StackAction[]{step});
            return this.copy(this.require_operator, this.right, this.left, ops, op_steps, this.affixes, this.affix_steps);
        }

        Self _left(rule left) {
            if (this.left != null) {
                throw new IllegalStateException("Trying to redefine the left operand.");
            }
            return this.copy(this.require_operator, this.right, left.get(), this.infixes, this.infix_steps, this.affixes, this.affix_steps);
        }

        Self _right(rule right) {
            if (this.right != null) {
                throw new IllegalStateException("Trying to redefine the right operand.");
            }
            return this.copy(this.require_operator, right.get(), this.left, this.infixes, this.infix_steps, this.affixes, this.affix_steps);
        }

        Self affix(rule op, StackAction.Push step) {
            Parser[] affixes = (Parser[])NArrays.append((Object[])this.affixes, (Object[])new Parser[]{op.get()});
            StackAction[] affix_steps = (StackAction[])NArrays.append((Object[])this.affix_steps, (Object[])new StackAction[]{step});
            return this.copy(this.require_operator, this.right, this.left, this.infixes, this.infix_steps, affixes, affix_steps);
        }

        Self require_operator() {
            if (this.require_operator) {
                throw new IllegalStateException("Specifiying that an operator is required twice.");
            }
            return this.copy(true, this.right, this.left, this.infixes, this.infix_steps, this.affixes, this.affix_steps);
        }
    }

    public final class CollectBuilder {
        private final Parser parser;
        private final int lookback;
        private final boolean peek_only;
        private final boolean collect_on_fail;

        CollectBuilder(Parser parser, int lookback, boolean peek_only, boolean collect_on_fail) {
            this.parser = parser;
            this.lookback = lookback;
            this.peek_only = peek_only;
            this.collect_on_fail = collect_on_fail;
        }

        public CollectBuilder lookback(int lookback) {
            if (this.lookback != 0) {
                throw new IllegalStateException("Trying to redefine the lookback on rule wrapper holding: " + this.parser);
            }
            return new CollectBuilder(this.parser, lookback, this.peek_only, this.collect_on_fail);
        }

        public CollectBuilder peek_only() {
            if (this.peek_only) {
                throw new IllegalStateException("Attempting to set the peek_only property twice on rule wrapper holding: " + this.parser);
            }
            return new CollectBuilder(this.parser, this.lookback, true, this.collect_on_fail);
        }

        public CollectBuilder also_on_fail() {
            if (this.collect_on_fail) {
                throw new IllegalStateException("Attempting to set the collect_on_fail property twice on rule wrapper holding: " + this.parser);
            }
            return new CollectBuilder(this.parser, this.lookback, this.peek_only, true);
        }

        public rule action(StackAction.ActionWithParse action) {
            return new rule(new Collect("collect", this.parser, this.lookback, this.collect_on_fail, !this.peek_only, action));
        }

        public rule action_with_string(StackAction.ActionWithString action) {
            return new rule(new Collect("collect_with_string", this.parser, this.lookback, this.collect_on_fail, !this.peek_only, action));
        }

        public rule action_with_list(StackAction.ActionWithList action) {
            return new rule(new Collect("collect_with_list", this.parser, this.lookback, this.collect_on_fail, !this.peek_only, action));
        }

        public rule push(StackAction.Push action) {
            return new rule(new Collect("push", this.parser, this.lookback, this.collect_on_fail, !this.peek_only, action));
        }

        public rule push_string_match() {
            return new rule(new Collect("push_string_match", this.parser, this.lookback, this.collect_on_fail, !this.peek_only, (p, xs, str) -> p.stack.push(str)));
        }

        public rule push_list_match() {
            return new rule(new Collect("push_list_match", this.parser, this.lookback, this.collect_on_fail, !this.peek_only, (p, xs, lst) -> p.stack.push(lst)));
        }

        public <T> rule as_list(Class<T> klass) {
            return new rule(new Collect("as_list", this.parser, this.lookback, this.collect_on_fail, !this.peek_only, (p, xs) -> Arrays.asList((Object[])Util.cast((Object)xs))));
        }
    }

    public final class rule {
        private final Parser parser;

        private rule(Parser parser) {
            this.parser = parser;
        }

        public DSL dsl() {
            return DSL.this;
        }

        public rule named(String name) {
            if (this.parser instanceof Collect) {
                ((Collect)this.parser).name = name;
            } else if (this.parser instanceof CharPredicate) {
                ((CharPredicate)this.parser).name = name;
            } else if (this.parser instanceof ObjectPredicate) {
                ((ObjectPredicate)this.parser).name = name;
            } else if (this.parser instanceof ContextPredicate) {
                ((ContextPredicate)this.parser).name = name;
            } else {
                throw new Error("Wrapped parser doesn't have a name property: " + this);
            }
            return this;
        }

        public Parser get() {
            return this.parser;
        }

        public String toString() {
            return this.parser.toString();
        }

        public rule not() {
            return new rule(new Not(this.parser));
        }

        public rule ahead() {
            return new rule(new Lookahead(this.parser));
        }

        public rule opt() {
            return new rule(new Optional(this.parser));
        }

        public rule repeat(int n) {
            return new rule(new Repeat(n, true, this.parser));
        }

        public rule at_least(int min) {
            return new rule(new Repeat(min, false, this.parser));
        }

        public rule sep(int min, Object separator) {
            return new rule(new Around(min, false, false, this.parser, DSL.this.compile(separator)));
        }

        public rule sep_exact(int n, Object separator) {
            return new rule(new Around(n, true, false, this.parser, DSL.this.compile(separator)));
        }

        public rule sep_trailing(int min, Object separator) {
            return new rule(new Around(min, false, true, this.parser, DSL.this.compile(separator)));
        }

        public rule word() {
            return new rule(new Sequence(this.parser, DSL.this.ws()));
        }

        public rule guarded() {
            return new rule(new GuardedRecursion(this.parser));
        }

        public rule token() {
            return new rule(DSL.this.tokens.token_parser(this.parser));
        }

        public CollectBuilder collect() {
            return new CollectBuilder(this.parser, 0, false, false);
        }

        public rule push(StackAction.Push action) {
            return this.collect().push(action);
        }

        public rule as_bool() {
            return new rule(new Collect("as_bool", new Optional(this.parser), 0, true, false, (p, xs) -> xs != null));
        }

        public rule as_val(Object value) {
            return new rule(new Collect("as_val", this.parser, 0, false, false, (p, xs) -> value));
        }

        public rule maybe() {
            return new rule(new Collect("maybe", this.parser, 0, true, false, (p, xs) -> {
                if (xs == null) {
                    p.stack.push((Object)null);
                }
            }));
        }

        public rule memo() {
            return this.memo((Function<Parse, Object>)null);
        }

        public rule memo(Function<Parse, Object> extractor) {
            ParseState<Memoizer> memoizer = new ParseState<Memoizer>(new Slot((Object)this.parser), () -> new MemoTable(false));
            return new rule(new Memo(this.parser, memoizer, extractor));
        }

        public rule memo(int n) {
            return this.memo(n, null);
        }

        public rule memo(int n, Function<Parse, Object> extractor) {
            if (n <= 0) {
                throw new IllegalArgumentException("A memo cache must have a strictly positive number of entries.");
            }
            ParseState<Memoizer> memoizer = new ParseState<Memoizer>(new Slot((Object)this.parser), () -> new MemoCache(n, false));
            return new rule(new Memo(this.parser, memoizer, extractor));
        }

        public rule memo(ParseState<Memoizer> memoizer) {
            return new rule(new Memo(this.parser, memoizer, null));
        }

        public rule memo(ParseState<Memoizer> memoizer, Function<Parse, Object> extractor) {
            return new rule(new Memo(this.parser, memoizer, extractor));
        }
    }
}

