/*
 * Decompiled with CFR 0.152.
 */
package norswap.autumn;

import java.util.List;
import java.util.Objects;
import norswap.autumn.DSL;
import norswap.autumn.Parse;
import norswap.autumn.ParseOptions;
import norswap.autumn.ParseResult;
import norswap.autumn.Parser;

public final class Autumn {
    private static final String warning = "Stack overflow during parse. Maybe your grammar is not well-formed (contains left-recursion or repetition over nullable parsers)? Re-run the parse with options ParseOptions#well_formedness_check or  ParseOptions#well_formedness_checker to verify.";

    private Autumn() {
    }

    public static ParseResult parse(Parser parser, String string, ParseOptions options) {
        Objects.requireNonNull(parser, "Parser cannot be null.");
        Objects.requireNonNull(string, "Input string cannot be null.");
        Objects.requireNonNull(options, "Parse options cannot be null.");
        try {
            return Parse.run(parser, string, null, options);
        }
        catch (StackOverflowError e) {
            throw new PotentiallyMalformedGrammarError(e);
        }
    }

    public static ParseResult parse(Parser parser, List<?> list, ParseOptions options) {
        Objects.requireNonNull(parser, "Parser cannot be null.");
        Objects.requireNonNull(list, "Input list cannot be null.");
        Objects.requireNonNull(options, "Parse options cannot be null.");
        try {
            return Parse.run(parser, null, list, options);
        }
        catch (StackOverflowError e) {
            throw new PotentiallyMalformedGrammarError(e);
        }
    }

    public static ParseResult parse(DSL.rule rule2, String string, ParseOptions options) {
        Objects.requireNonNull(rule2, "Rule cannot be null.");
        return Autumn.parse(rule2.get(), string, options);
    }

    public static ParseResult parse(DSL.rule rule2, List<?> list, ParseOptions options) {
        Objects.requireNonNull(rule2, "Rule cannot be null.");
        return Autumn.parse(rule2.get(), list, options);
    }

    private static class PotentiallyMalformedGrammarError
    extends Error {
        PotentiallyMalformedGrammarError(StackOverflowError e) {
            super(Autumn.warning, e, true, false);
        }
    }
}

