/*
 * Decompiled with CFR 0.152.
 */
package com.github.noonmaru.math;

public final class MathHelper {
    public static final float PI = (float)Math.PI;
    private static final float[] SIN_TABLE = new float[65536];

    public static float sin(float radians) {
        return SIN_TABLE[(int)(radians * 10430.378f) & 0xFFFF];
    }

    public static float sin(double radians) {
        return SIN_TABLE[(int)(radians * 10430.378) & 0xFFFF];
    }

    public static float cos(float radians) {
        return SIN_TABLE[(int)(radians * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float cos(double radians) {
        return SIN_TABLE[(int)(radians * 10430.378 + 16384.0) & 0xFFFF];
    }

    public static float toRadians(float degrees) {
        return degrees / 180.0f * (float)Math.PI;
    }

    public static double toRadians(double degrees) {
        return degrees / 180.0 * Math.PI;
    }

    public static float toDegrees(float radians) {
        return radians * 180.0f / (float)Math.PI;
    }

    public static double toDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    public static int square(int i) {
        return i * i;
    }

    public static float square(float f) {
        return f * f;
    }

    public static double square(double d) {
        return d * d;
    }

    public static int clamp(int i, int min, int max) {
        if (i < min) {
            return min;
        }
        if (i > max) {
            return max;
        }
        return i;
    }

    public static long clamp(long i, long min, long max) {
        if (i < min) {
            return min;
        }
        if (i > max) {
            return max;
        }
        return i;
    }

    public static float clamp(float i, float min, float max) {
        if (i < min) {
            return min;
        }
        if (i > max) {
            return max;
        }
        return i;
    }

    public static double clamp(double i, double min, double max) {
        if (i < min) {
            return min;
        }
        if (i > max) {
            return max;
        }
        return i;
    }

    public static int round(float f) {
        return (int)(f + 0.5f);
    }

    public static int round(double d) {
        return (int)(d + 0.5);
    }

    public static int ceil(float f) {
        int i = (int)f;
        return f > (float)i ? i + 1 : i;
    }

    public static int ceil(double d) {
        int i = (int)d;
        return d > (double)i ? i + 1 : i;
    }

    public static int gcd(int a, int b) {
        int temp = 0;
        while (a != 0) {
            if (a < b) {
                temp = a;
                a = b;
                b = temp;
            }
            a -= b;
        }
        return b;
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathHelper.SIN_TABLE[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    }
}

