/*
 * Decompiled with CFR 0.152.
 */
package com.github.noonmaru.collections.mut;

import com.github.noonmaru.collections.Node;
import com.github.noonmaru.collections.mut.LinkedNodeList;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedList;

public class EventNodeList<E>
extends LinkedNodeList<E> {
    private static final int HANDLER_LENGTH = EventType.values().length;
    private final Handler<E>[] handlers = (Handler[])Array.newInstance(Handler.class, HANDLER_LENGTH);

    public EventNodeList() {
    }

    public EventNodeList(Collection<? extends E> c) {
        this.addAll(c);
    }

    public void registerListener(EventType eventType, NodeListener<E> listener) {
        Handler<E>[] handlers = this.handlers;
        int index = eventType.ordinal();
        Handler<E> handler = handlers[index];
        if (handler == null) {
            handler = new Handler();
            handlers[index] = handler;
        }
        handler.register(listener);
    }

    private void callEvent(EventType type, LinkedNodeList.NodeImpl<E> node, E item) {
        Handler<E> handler = this.handlers[type.ordinal()];
        if (handler != null) {
            for (NodeListener<E> listener : handler.getListeners()) {
                try {
                    listener.onEvent(EventType.LINK, node, item);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private LinkedNodeList.NodeImpl<E> onLink(LinkedNodeList.NodeImpl<E> node, E item) {
        this.callEvent(EventType.LINK, node, item);
        return node;
    }

    @Override
    LinkedNodeList.NodeImpl<E> linkFirst(E e) {
        return this.onLink(super.linkFirst(e), e);
    }

    @Override
    LinkedNodeList.NodeImpl<E> linkLast(E e) {
        return this.onLink(super.linkLast(e), e);
    }

    @Override
    LinkedNodeList.NodeImpl<E> linkBefore(E e, LinkedNodeList.NodeImpl<E> node) {
        return this.onLink(super.linkBefore(e, node), e);
    }

    @Override
    LinkedNodeList.NodeImpl<E> linkAfter(E e, LinkedNodeList.NodeImpl<E> node) {
        return this.onLink(super.linkAfter(e, node), e);
    }

    private E onUnlink(LinkedNodeList.NodeImpl<E> x, E item) {
        this.callEvent(EventType.UNLINK, x, item);
        return item;
    }

    @Override
    E unlink(LinkedNodeList.NodeImpl<E> x) {
        return this.onUnlink(x, super.unlink(x));
    }

    @Override
    E unlinkFirst(LinkedNodeList.NodeImpl<E> f) {
        return this.onUnlink(f, super.unlinkFirst(f));
    }

    @Override
    E unlinkLast(LinkedNodeList.NodeImpl<E> l) {
        return this.onUnlink(l, super.unlinkLast(l));
    }

    private static class Handler<E> {
        private final LinkedList<NodeListener<E>> list = new LinkedList();
        private NodeListener<E>[] listeners;

        private Handler() {
        }

        void register(NodeListener<E> listener) {
            this.list.add(listener);
            this.listeners = null;
        }

        NodeListener<E>[] getListeners() {
            NodeListener<E>[] listeners = this.listeners;
            if (listeners == null) {
                LinkedList<NodeListener<E>> list = this.list;
                this.listeners = listeners = list.toArray((NodeListener[])Array.newInstance(NodeListener.class, list.size()));
            }
            return listeners;
        }
    }

    @FunctionalInterface
    public static interface NodeListener<E> {
        public void onEvent(EventType var1, Node<E> var2, E var3);
    }

    public static enum EventType {
        LINK,
        UNLINK;

    }
}

