/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.yarn.task;

import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.exec.NodeExecConfiguration;
import com.github.gradle.node.task.BaseTask;
import com.github.gradle.node.util.DefaultProjectApiHelper;
import com.github.gradle.node.yarn.exec.YarnExecRunner;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010,\u001a\u00020-H\u0007J\u0014\u0010\f\u001a\u00020-2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0013\u0010\u0016\u001a\u00020\u00178G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u00020\u001f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u00020'8G\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0019\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0007\u00a8\u0006."}, d2={"Lcom/github/gradle/node/yarn/task/YarnTask;", "Lcom/github/gradle/node/task/BaseTask;", "()V", "args", "Lorg/gradle/api/provider/ListProperty;", "", "getArgs", "()Lorg/gradle/api/provider/ListProperty;", "environment", "Lorg/gradle/api/provider/MapProperty;", "getEnvironment", "()Lorg/gradle/api/provider/MapProperty;", "execOverrides", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/Action;", "Lorg/gradle/process/ExecSpec;", "getExecOverrides", "()Lorg/gradle/api/provider/Property;", "ignoreExitValue", "", "kotlin.jvm.PlatformType", "getIgnoreExitValue", "nodeExtension", "Lcom/github/gradle/node/NodeExtension;", "getNodeExtension", "()Lcom/github/gradle/node/NodeExtension;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "getObjects", "()Lorg/gradle/api/model/ObjectFactory;", "projectHelper", "Lcom/github/gradle/node/util/DefaultProjectApiHelper;", "getProjectHelper", "()Lcom/github/gradle/node/util/DefaultProjectApiHelper;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "workingDir", "Lorg/gradle/api/file/DirectoryProperty;", "getWorkingDir", "()Lorg/gradle/api/file/DirectoryProperty;", "yarnCommand", "getYarnCommand", "exec", "", "gradle-node-plugin"})
public abstract class YarnTask
extends BaseTask {
    @NotNull
    private final ListProperty<String> yarnCommand;
    @NotNull
    private final ListProperty<String> args;
    @NotNull
    private final Property<Boolean> ignoreExitValue;
    @NotNull
    private final DirectoryProperty workingDir;
    @NotNull
    private final MapProperty<String, String> environment;
    @NotNull
    private final Property<Action<ExecSpec>> execOverrides;
    @NotNull
    private final DefaultProjectApiHelper projectHelper;
    @NotNull
    private final NodeExtension nodeExtension;

    @Inject
    @NotNull
    public abstract ObjectFactory getObjects();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    @Optional
    @Input
    @NotNull
    public final ListProperty<String> getYarnCommand() {
        return this.yarnCommand;
    }

    @Optional
    @Input
    @NotNull
    public final ListProperty<String> getArgs() {
        return this.args;
    }

    @Input
    @NotNull
    public final Property<Boolean> getIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    @Internal
    @NotNull
    public final DirectoryProperty getWorkingDir() {
        return this.workingDir;
    }

    @Input
    @NotNull
    public final MapProperty<String, String> getEnvironment() {
        return this.environment;
    }

    @Internal
    @NotNull
    public final Property<Action<ExecSpec>> getExecOverrides() {
        return this.execOverrides;
    }

    @Internal
    @NotNull
    public final DefaultProjectApiHelper getProjectHelper() {
        return this.projectHelper;
    }

    @Internal
    @NotNull
    public final NodeExtension getNodeExtension() {
        return this.nodeExtension;
    }

    public final void execOverrides(@NotNull Action<ExecSpec> execOverrides) {
        Intrinsics.checkNotNullParameter(execOverrides, (String)"execOverrides");
        this.execOverrides.set(execOverrides);
    }

    @TaskAction
    public final void exec() {
        Object object = this.yarnCommand.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"yarnCommand.get()");
        Collection collection = (Collection)object;
        Object object2 = this.args.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"args.get()");
        List command = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object2));
        Object object3 = this.environment.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"environment.get()");
        Map map = (Map)object3;
        Provider provider = this.workingDir.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"workingDir.asFile");
        File file = (File)provider.getOrNull();
        Object object4 = this.ignoreExitValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"ignoreExitValue.get()");
        NodeExecConfiguration nodeExecConfiguration = new NodeExecConfiguration(command, map, file, (Boolean)object4, (Action<ExecSpec>)((Action)this.execOverrides.getOrNull()));
        Object object5 = this.getObjects().newInstance(YarnExecRunner.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"objects.newInstance(YarnExecRunner::class.java)");
        YarnExecRunner yarnExecRunner = (YarnExecRunner)object5;
        this.setResult(yarnExecRunner.executeYarnCommand(this.projectHelper, this.nodeExtension, nodeExecConfiguration, this.getVariantComputer$gradle_node_plugin()));
    }

    /*
     * WARNING - void declaration
     */
    public YarnTask() {
        void $this$newInstance$iv;
        ObjectFactory $this$listProperty$iv = this.getObjects();
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.yarnCommand = listProperty;
        $this$listProperty$iv = this.getObjects();
        $i$f$listProperty = false;
        ListProperty listProperty2 = $this$listProperty$iv.listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty2, (String)"listProperty(T::class.java)");
        this.args = listProperty2;
        ObjectFactory $this$property$iv = this.getObjects();
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        Property property2 = property.convention((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"objects.property<Boolean>().convention(false)");
        this.ignoreExitValue = property2;
        DirectoryProperty directoryProperty = this.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.workingDir = directoryProperty;
        ObjectFactory $this$mapProperty$iv = this.getObjects();
        boolean $i$f$mapProperty = false;
        MapProperty mapProperty = $this$mapProperty$iv.mapProperty(String.class, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty, (String)"mapProperty(K::class.java, V::class.java)");
        this.environment = mapProperty;
        $this$property$iv = this.getObjects();
        $i$f$property = false;
        Property property3 = $this$property$iv.property(Action.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.execOverrides = property3;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        $this$property$iv = objectFactory;
        Object[] parameters$iv = new Object[]{};
        boolean $i$f$newInstance = false;
        this.projectHelper = (DefaultProjectApiHelper)$this$newInstance$iv.newInstance(DefaultProjectApiHelper.class, Arrays.copyOf(parameters$iv, parameters$iv.length));
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.nodeExtension = NodeExtension.Companion.get(project2);
        this.setGroup("Node");
        this.dependsOn(new Object[]{"yarnSetup"});
    }
}

