/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.task;

import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.task.BaseTask;
import com.github.gradle.node.task.NodeSetupTask;
import com.github.gradle.node.util.DefaultProjectApiHelper;
import com.github.gradle.node.util.Platform;
import com.github.gradle.node.variant.VariantComputerKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0007J&\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002J\b\u0010*\u001a\u00020 H\u0002J\b\u0010+\u001a\u00020 H\u0002R!\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u00020\u00188G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Lcom/github/gradle/node/task/NodeSetupTask;", "Lcom/github/gradle/node/task/BaseTask;", "()V", "download", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getDownload", "()Lorg/gradle/api/provider/Property;", "nodeArchiveFile", "Lorg/gradle/api/file/RegularFileProperty;", "getNodeArchiveFile", "()Lorg/gradle/api/file/RegularFileProperty;", "nodeDir", "Lorg/gradle/api/file/DirectoryProperty;", "getNodeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "nodeExtension", "Lcom/github/gradle/node/NodeExtension;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "getObjects", "()Lorg/gradle/api/model/ObjectFactory;", "projectHelper", "Lcom/github/gradle/node/util/DefaultProjectApiHelper;", "getProjectHelper", "()Lcom/github/gradle/node/util/DefaultProjectApiHelper;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "deleteExistingNode", "", "exec", "fixBrokenSymlink", "name", "", "nodeBinDirPath", "Ljava/nio/file/Path;", "nodeDirProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "setExecutableFlag", "unpackNodeArchive", "Companion", "gradle-node-plugin"})
public abstract class NodeSetupTask
extends BaseTask {
    private final NodeExtension nodeExtension;
    @NotNull
    private final Property<Boolean> download;
    @NotNull
    private final RegularFileProperty nodeArchiveFile;
    @NotNull
    private final DefaultProjectApiHelper projectHelper;
    @NotNull
    public static final String NAME = "nodeSetup";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Inject
    @NotNull
    public abstract ObjectFactory getObjects();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    @Input
    @NotNull
    public final Property<Boolean> getDownload() {
        return this.download;
    }

    @InputFile
    @NotNull
    public final RegularFileProperty getNodeArchiveFile() {
        return this.nodeArchiveFile;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getNodeDir();

    @Internal
    @NotNull
    public final DefaultProjectApiHelper getProjectHelper() {
        return this.projectHelper;
    }

    @TaskAction
    public final void exec() {
        this.deleteExistingNode();
        this.unpackNodeArchive();
        this.setExecutableFlag();
    }

    private final void deleteExistingNode() {
        this.projectHelper.delete((Action<DeleteSpec>)new Action(this){
            final /* synthetic */ NodeSetupTask this$0;

            public final void execute(@NotNull DeleteSpec $this$delete) {
                Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$receiver");
                Object[] objectArray = new Object[1];
                Directory directory = ((Directory)this.this$0.getNodeDir().get()).dir("../");
                Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"nodeDir.get().dir(\"../\")");
                objectArray[0] = directory.getAsFileTree().matching((Action)deleteExistingNode.1.INSTANCE);
                $this$delete.delete(objectArray);
            }
            {
                this.this$0 = nodeSetupTask;
            }
        });
    }

    private final void unpackNodeArchive() {
        Object object = this.nodeArchiveFile.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodeArchiveFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"nodeArchiveFile.get().asFile");
        File archiveFile = file;
        DirectoryProperty nodeDirProvider = this.nodeExtension.getResolvedNodeDir();
        Provider<Directory> nodeBinDirProvider = this.getVariantComputer$gradle_node_plugin().computeNodeBinDir((Provider<Directory>)((Provider)nodeDirProvider), this.nodeExtension.getResolvedPlatform());
        Provider provider = nodeDirProvider.map((Transformer)unpackNodeArchive.archivePath.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"nodeDirProvider.map { it.dir(\"../\") }");
        Provider archivePath2 = provider;
        String string = archiveFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"archiveFile.name");
        if (StringsKt.endsWith$default((String)string, (String)"zip", (boolean)false, (int)2, null)) {
            this.projectHelper.copy((Action<CopySpec>)new Action(this, archiveFile, archivePath2){
                final /* synthetic */ NodeSetupTask this$0;
                final /* synthetic */ File $archiveFile;
                final /* synthetic */ Provider $archivePath;

                public final void execute(@NotNull CopySpec $this$copy) {
                    Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$receiver");
                    $this$copy.from(new Object[]{this.this$0.getProjectHelper().zipTree(this.$archiveFile)});
                    $this$copy.into((Object)this.$archivePath);
                }
                {
                    this.this$0 = nodeSetupTask;
                    this.$archiveFile = file;
                    this.$archivePath = provider;
                }
            });
        } else {
            Path nodeBinDirPath;
            this.projectHelper.copy((Action<CopySpec>)new Action(this, archiveFile, archivePath2){
                final /* synthetic */ NodeSetupTask this$0;
                final /* synthetic */ File $archiveFile;
                final /* synthetic */ Provider $archivePath;

                public final void execute(@NotNull CopySpec $this$copy) {
                    Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$receiver");
                    $this$copy.from(new Object[]{this.this$0.getProjectHelper().tarTree(this.$archiveFile)});
                    $this$copy.into((Object)this.$archivePath);
                }
                {
                    this.this$0 = nodeSetupTask;
                    this.$archiveFile = file;
                    this.$archivePath = provider;
                }
            });
            Object object2 = nodeBinDirProvider.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"nodeBinDirProvider.get()");
            Path path = nodeBinDirPath = ((Directory)object2).getAsFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"nodeBinDirPath");
            this.fixBrokenSymlink("npm", path, (Provider<Directory>)((Provider)nodeDirProvider));
            this.fixBrokenSymlink("npx", nodeBinDirPath, (Provider<Directory>)((Provider)nodeDirProvider));
        }
    }

    private final void fixBrokenSymlink(String name2, Path nodeBinDirPath, Provider<Directory> nodeDirProvider) {
        Path script = nodeBinDirPath.resolve(name2);
        Provider<String> scriptFile = VariantComputerKt.computeNpmScriptFile(nodeDirProvider, name2, ((Platform)this.nodeExtension.getResolvedPlatform().get()).isWindows());
        if (Files.deleteIfExists(script)) {
            Files.createSymbolicLink(script, nodeBinDirPath.relativize(Paths.get((String)scriptFile.get(), new String[0])), new FileAttribute[0]);
        }
    }

    private final void setExecutableFlag() {
        if (!((Platform)this.nodeExtension.getResolvedPlatform().get()).isWindows()) {
            Provider<Directory> nodeBinDirProvider = this.getVariantComputer$gradle_node_plugin().computeNodeBinDir((Provider<Directory>)((Provider)this.nodeExtension.getResolvedNodeDir()), this.nodeExtension.getResolvedPlatform());
            Provider<String> nodeExecProvider = VariantComputerKt.computeNodeExec(this.nodeExtension, nodeBinDirProvider);
            new File((String)nodeExecProvider.get()).setExecutable(true);
        }
    }

    public NodeSetupTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.nodeExtension = NodeExtension.Companion.get(project);
        this.download = this.nodeExtension.getDownload();
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.nodeArchiveFile = regularFileProperty;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Object object = project2.getObjects().newInstance(DefaultProjectApiHelper.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.objects.newInsta\u2026ectApiHelper::class.java)");
        this.projectHelper = (DefaultProjectApiHelper)object;
        this.setGroup("Node");
        this.setDescription("Download and install a local node/npm version.");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Object object = nodeExtension.getDownload().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodeExtension.download.get()");
                return (Boolean)object;
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/gradle/node/task/NodeSetupTask$Companion;", "", "()V", "NAME", "", "gradle-node-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

