/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.task;

import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.task.NodeSetupTask;
import com.github.gradle.node.util.PlatformHelper;
import com.github.gradle.node.variant.VariantComputer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\b\u0010#\u001a\u00020\u001aH\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0005H\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R)\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\t\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0013\u0010\u0007R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/github/gradle/node/task/NodeSetupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "archiveDependency", "Lorg/gradle/api/provider/Provider;", "", "getArchiveDependency", "()Lorg/gradle/api/provider/Provider;", "archiveDependency$delegate", "Lkotlin/Lazy;", "download", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getDownload", "()Lorg/gradle/api/provider/Property;", "download$delegate", "nodeDir", "Lorg/gradle/api/file/Directory;", "getNodeDir", "nodeDir$delegate", "nodeExtension", "Lcom/github/gradle/node/NodeExtension;", "variantComputer", "Lcom/github/gradle/node/variant/VariantComputer;", "addRepository", "", "distUrl", "addRepositoryIfNeeded", "deleteExistingNode", "exec", "getNodeArchiveFile", "Ljava/io/File;", "resolveSingle", "name", "setExecutableFlag", "unpackNodeArchive", "Companion", "gradle-node-plugin"})
public class NodeSetupTask
extends DefaultTask {
    private final VariantComputer variantComputer = new VariantComputer(null, 1, null);
    private final NodeExtension nodeExtension;
    @NotNull
    private final Lazy download$delegate;
    @NotNull
    private final Lazy archiveDependency$delegate;
    @NotNull
    private final Lazy nodeDir$delegate;
    @NotNull
    public static final String NAME = "nodeSetup";
    public static final Companion Companion = new Companion(null);

    @Input
    @NotNull
    public final Property<Boolean> getDownload() {
        Lazy lazy = this.download$delegate;
        NodeSetupTask nodeSetupTask = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Property)lazy.getValue();
    }

    @Input
    @NotNull
    public final Provider<String> getArchiveDependency() {
        Lazy lazy = this.archiveDependency$delegate;
        NodeSetupTask nodeSetupTask = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Provider)lazy.getValue();
    }

    @OutputDirectory
    @NotNull
    public final Provider<Directory> getNodeDir() {
        Lazy lazy = this.nodeDir$delegate;
        NodeSetupTask nodeSetupTask = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Provider)lazy.getValue();
    }

    @TaskAction
    public final void exec() {
        this.addRepositoryIfNeeded();
        Object object = this.variantComputer.computeArchiveDependency(this.nodeExtension).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"variantComputer.computeA\u2026ency(nodeExtension).get()");
        String archiveDependency2 = (String)object;
        this.deleteExistingNode();
        this.unpackNodeArchive(archiveDependency2);
        this.setExecutableFlag();
    }

    private final void deleteExistingNode() {
        this.getProject().delete(new Object[]{((Directory)this.getNodeDir().get()).dir("../")});
    }

    private final void unpackNodeArchive(String archiveDependency2) {
        File nodeArchiveFile = this.getNodeArchiveFile(archiveDependency2);
        Provider<Directory> nodeDirProvider = this.variantComputer.computeNodeDir(this.nodeExtension);
        Provider<Directory> nodeBinDirProvider = this.variantComputer.computeNodeBinDir(nodeDirProvider);
        String string = nodeArchiveFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nodeArchiveFile.name");
        if (StringsKt.endsWith$default((String)string, (String)"zip", (boolean)false, (int)2, null)) {
            Intrinsics.checkExpressionValueIsNotNull((Object)this.getProject().copy((Action)new Action<CopySpec>(this, nodeArchiveFile, nodeDirProvider){
                final /* synthetic */ NodeSetupTask this$0;
                final /* synthetic */ File $nodeArchiveFile;
                final /* synthetic */ Provider $nodeDirProvider;

                public final void execute(@NotNull CopySpec $this$copy) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$copy, (String)"$receiver");
                    $this$copy.from(new Object[]{this.this$0.getProject().zipTree((Object)this.$nodeArchiveFile)});
                    $this$copy.into((Object)this.$nodeDirProvider.map((Transformer)unpackNodeArchive.1.INSTANCE));
                }
                {
                    this.this$0 = nodeSetupTask;
                    this.$nodeArchiveFile = file;
                    this.$nodeDirProvider = provider;
                }
            }), (String)"project.copy {\n         \u2026r(\"../\") })\n            }");
        } else {
            this.getProject().copy((Action)new Action<CopySpec>(this, nodeArchiveFile, nodeDirProvider){
                final /* synthetic */ NodeSetupTask this$0;
                final /* synthetic */ File $nodeArchiveFile;
                final /* synthetic */ Provider $nodeDirProvider;

                public final void execute(@NotNull CopySpec $this$copy) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$copy, (String)"$receiver");
                    $this$copy.from(new Object[]{this.this$0.getProject().tarTree((Object)this.$nodeArchiveFile)});
                    $this$copy.into((Object)this.$nodeDirProvider.map((Transformer)unpackNodeArchive.1.INSTANCE));
                }
                {
                    this.this$0 = nodeSetupTask;
                    this.$nodeArchiveFile = file;
                    this.$nodeDirProvider = provider;
                }
            });
            Object object = nodeBinDirProvider.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeBinDirProvider.get()");
            Path nodeBinDirPath = ((Directory)object).getAsFile().toPath();
            Path npm = nodeBinDirPath.resolve("npm");
            Object object2 = this.variantComputer.computeNpmScriptFile(nodeDirProvider, "npm").get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"variantComputer.computeN\u2026DirProvider, \"npm\").get()");
            String npmScriptFile = (String)object2;
            if (Files.deleteIfExists(npm)) {
                Files.createSymbolicLink(npm, nodeBinDirPath.relativize(Paths.get(npmScriptFile, new String[0])), new FileAttribute[0]);
            }
            Path npx = nodeBinDirPath.resolve("npx");
            Object object3 = this.variantComputer.computeNpmScriptFile(nodeDirProvider, "npx").get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"variantComputer.computeN\u2026DirProvider, \"npx\").get()");
            String npxScriptFile = (String)object3;
            if (Files.deleteIfExists(npx)) {
                Files.createSymbolicLink(npx, nodeBinDirPath.relativize(Paths.get(npxScriptFile, new String[0])), new FileAttribute[0]);
            }
        }
    }

    private final void setExecutableFlag() {
        if (!PlatformHelper.Companion.getINSTANCE().isWindows()) {
            Provider<Directory> nodeDirProvider = this.variantComputer.computeNodeDir(this.nodeExtension);
            Provider<Directory> nodeBinDirProvider = this.variantComputer.computeNodeBinDir(nodeDirProvider);
            Provider<String> nodeExecProvider = this.variantComputer.computeNodeExec(this.nodeExtension, nodeBinDirProvider);
            new File((String)nodeExecProvider.get()).setExecutable(true);
        }
    }

    private final File getNodeArchiveFile(String archiveDependency2) {
        return this.resolveSingle(archiveDependency2);
    }

    private final File resolveSingle(String name) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Dependency dependency = project.getDependencies().create((Object)name);
        Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"project.dependencies.create(name)");
        Dependency dep = dependency;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Configuration configuration = project2.getConfigurations().detachedConfiguration(new Dependency[]{dep});
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.configurations.detachedConfiguration(dep)");
        Configuration conf = configuration;
        conf.setTransitive(false);
        Set set = conf.resolve();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"conf.resolve()");
        Object object = CollectionsKt.single((Iterable)set);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"conf.resolve().single()");
        return (File)object;
    }

    private final void addRepositoryIfNeeded() {
        block0: {
            String string = (String)this.nodeExtension.getDistBaseUrl().getOrNull();
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String string3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
            this.addRepository(string3);
        }
    }

    private final void addRepository(String distUrl) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getRepositories().ivy((Action)new Action<IvyArtifactRepository>(distUrl){
            final /* synthetic */ String $distUrl;

            public final void execute(@NotNull IvyArtifactRepository $this$ivy) {
                Intrinsics.checkParameterIsNotNull((Object)$this$ivy, (String)"$receiver");
                $this$ivy.setUrl((Object)this.$distUrl);
                $this$ivy.patternLayout((Action)addRepository.1.INSTANCE);
                $this$ivy.metadataSources((Action)addRepository.2.INSTANCE);
            }
            {
                this.$distUrl = string;
            }
        });
    }

    public NodeSetupTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.nodeExtension = NodeExtension.Companion.get(project);
        this.download$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Property<Boolean>>(this){
            final /* synthetic */ NodeSetupTask this$0;

            @NotNull
            public final Property<Boolean> invoke() {
                return NodeSetupTask.access$getNodeExtension$p(this.this$0).getDownload();
            }
            {
                this.this$0 = nodeSetupTask;
                super(0);
            }
        }));
        this.archiveDependency$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<String>>(this){
            final /* synthetic */ NodeSetupTask this$0;

            @NotNull
            public final Provider<String> invoke() {
                return NodeSetupTask.access$getVariantComputer$p(this.this$0).computeArchiveDependency(NodeSetupTask.access$getNodeExtension$p(this.this$0));
            }
            {
                this.this$0 = nodeSetupTask;
                super(0);
            }
        }));
        this.nodeDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Provider<Directory>>(this){
            final /* synthetic */ NodeSetupTask this$0;

            @NotNull
            public final Provider<Directory> invoke() {
                return NodeSetupTask.access$getVariantComputer$p(this.this$0).computeNodeDir(NodeSetupTask.access$getNodeExtension$p(this.this$0));
            }
            {
                this.this$0 = nodeSetupTask;
                super(0);
            }
        }));
        this.setGroup("Node");
        this.setDescription("Download and install a local node/npm version.");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Object object = nodeExtension.getDownload().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeExtension.download.get()");
                return (Boolean)object;
            }
        });
    }

    public static final /* synthetic */ VariantComputer access$getVariantComputer$p(NodeSetupTask $this) {
        return $this.variantComputer;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/gradle/node/task/NodeSetupTask$Companion;", "", "()V", "NAME", "", "gradle-node-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

